/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.dialogs.discountsystem.ConditionTemplateConverter;
import su.artix.discountmanager.dialogs.discountsystem.DiscountConditionValuePanel;
import su.artix.discountmanager.dialogs.discountsystem.ParsedControlsMeta;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControl;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCardCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCondition;
import su.artix.yuki.discount.condition.domain.xml.ConditionCustomeType;
import su.artix.yuki.discount.condition.domain.xml.ConditionTemplate;
import su.artix.yuki.discount.condition.domain.xml.ConditionTemplateValue;
import su.artix.yuki.discount.condition.domain.xml.ConditionType;
import su.artix.yuki.discount.condition.domain.xml.ConstListItem;
import su.artix.yuki.discount.condition.domain.xml.ConstructorWidgetType;
import su.artix.yuki.discount.condition.template.dao.ConditionCustomTypeDAO;

public class DiscountConditionWizardFillTemplatePage
extends WizardPage {
    private ConditionTemplate template;
    private DiscountCondition discountCondition;
    private String condition;
    private String description;
    private Map<ParsedControlsMeta, ConditionTemplateValue> metaTempValues;
    private DiscountConditionValuePanel valuePanel;
    private ConditionCustomTypeDAO customTypeDao;

    protected DiscountConditionWizardFillTemplatePage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.customTypeDao = Activator.getDefault().getBeanByClass(ConditionCustomTypeDAO.class);
        this.metaTempValues = new HashMap<ParsedControlsMeta, ConditionTemplateValue>(5);
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        this.setControl((Control)main);
        this.setPageComplete(false);
    }

    public void update(ConditionTemplate template1) {
        this.template = template1.copy();
        this.clearPanel();
        List<ParsedControlsMeta> metas = this.parseTemplate(this.template);
        this.valuePanel = new DiscountConditionValuePanel((Composite)this.getControl(), 0, metas);
        ((Composite)this.getControl()).layout();
        this.setPageComplete(true);
    }

    private List<ParsedControlsMeta> parseTemplate(ConditionTemplate template1) {
        ArrayList<ParsedControlsMeta> metas = new ArrayList<ParsedControlsMeta>();
        ParsedControlsMeta meta = null;
        for (ConditionTemplateValue value : template1.getValues()) {
            ConstructorWidgetType wType = ConstructorWidgetType.getControlTypeFromString((String)value.getType());
            if (ConstructorWidgetType.Unknown == wType) {
                ConditionCustomeType customType = this.customTypeDao.getValueType(value.getType());
                meta = new ParsedControlsMeta(ConstructorWidgetType.getControlTypeFromString((String)customType.getValue().getXmlType()), value.getLabel());
                meta.setConstListType(customType.getValue().getMode());
                meta.setDefaultValue(value.getDefaultValue() != null ? value.getDefaultValue() : customType.getValue().getDefaultValue());
                for (ConstListItem item : customType.getValue().getList()) {
                    meta.addValue(item.getDisplay(), item.getValue());
                }
            } else {
                meta = new ParsedControlsMeta(wType, value.getLabel());
                if (value.getDefaultValue() != null) {
                    meta.setDefaultValue(value.getDefaultValue());
                }
            }
            this.metaTempValues.put(meta, value);
            metas.add(meta);
        }
        return metas;
    }

    private void clearPanel() {
        if (this.valuePanel != null) {
            Control[] controlArray = this.valuePanel.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            this.valuePanel.dispose();
        }
    }

    public DiscountCondition get() {
        Map<ParsedControlsMeta, DiscountConditionControl> controls = this.valuePanel.getControlsWithMetaMap();
        this.description = this.template.getSpecification();
        this.condition = this.template.getDefinition();
        for (Map.Entry<ParsedControlsMeta, DiscountConditionControl> entry : controls.entrySet()) {
            DiscountConditionControl control = entry.getValue();
            String tech = control.getText();
            String desc = control.getDesc();
            this.condition = StringUtils.replaceOnce((String)this.condition, (String)"${..}", (String)tech);
            this.description = StringUtils.replaceOnce((String)this.description, (String)"[..]", (String)desc);
            if (tech != null && tech.startsWith("u\"") && tech.endsWith("\"")) {
                tech = StringUtils.substringBetween((String)tech, (String)"u\"", (String)"\"");
            }
            this.metaTempValues.get(entry.getKey()).setDefaultValue(tech);
        }
        this.discountCondition = this.template.getType() == ConditionType.CARD ? new DiscountCardCondition() : new DiscountCondition();
        this.discountCondition.setCondition(this.condition);
        this.discountCondition.setDescription(this.description);
        this.discountCondition.setTemplate(ConditionTemplateConverter.convert(this.template));
        return this.discountCondition;
    }
}

