/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem.controls;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControlListener;

public class DiscountConditionDateControl
implements DiscountConditionControl {
    private DateTime dateTime;
    private Map<Integer, String> months;

    public DiscountConditionDateControl(Composite parent, String labelName, String defaultDate) {
        Label label = new Label(parent, 0);
        label.setText(labelName);
        this.dateTime = new DateTime(parent, 36);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.dateTime);
        this.setDate(defaultDate);
        this.months = new HashMap<Integer, String>();
        this.months.put(0, "\u044f\u043d\u0432\u0430\u0440\u044f");
        this.months.put(1, "\u0444\u0435\u0432\u0440\u0430\u043b\u044f");
        this.months.put(2, "\u043c\u0430\u0440\u0442\u0430");
        this.months.put(3, "\u0430\u043f\u0440\u0435\u043b\u044f");
        this.months.put(4, "\u043c\u0430\u044f");
        this.months.put(5, "\u0438\u044e\u043d\u044f");
        this.months.put(6, "\u0438\u044e\u043b\u044f");
        this.months.put(7, "\u0430\u0432\u0433\u0443\u0441\u0442\u0430");
        this.months.put(8, "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044f");
        this.months.put(9, "\u043e\u043a\u0442\u044f\u0431\u0440\u044f");
        this.months.put(10, "\u043d\u043e\u044f\u0431\u0440\u044f");
        this.months.put(11, "\u0434\u0435\u043a\u0430\u0431\u0440\u044f");
    }

    private void setDate(String defaultDate) {
        String def = defaultDate;
        if (def != null && !def.isEmpty()) {
            String[] values;
            if (def.startsWith("\"") && def.endsWith("\"")) {
                def = StringUtils.substringBetween((String)def, (String)"\"", (String)"\"");
            }
            if ((values = def.split("-")).length == 3) {
                try {
                    this.dateTime.setYear(Integer.valueOf(values[0].trim()).intValue());
                    this.dateTime.setMonth(Integer.valueOf(values[1].trim()) - 1);
                    this.dateTime.setDay(Integer.valueOf(values[2].trim()).intValue());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    @Override
    public String getText() {
        return "\"" + this.dateTime.getYear() + "-" + (this.dateTime.getMonth() + 1) + "-" + this.dateTime.getDay() + "\"";
    }

    @Override
    public String getDesc() {
        return String.valueOf(this.dateTime.getDay()) + " " + this.getMonthName(this.dateTime.getDay(), this.dateTime.getMonth()) + " " + this.dateTime.getYear();
    }

    private String getMonthName(int day, int index) {
        return this.months.get(index);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void addListener(final DiscountConditionControlListener listener) {
        this.dateTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                listener.exec();
            }
        });
    }
}

