/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.discount.condition.template.dao.impl;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.yuki.discount.condition.domain.xml.ConditionTemplate;
import su.artix.yuki.discount.condition.domain.xml.ConditionTemplateTag;
import su.artix.yuki.discount.condition.domain.xml.ConditionTemplateTagHolder;
import su.artix.yuki.discount.condition.domain.xml.ConditionTemplatesHolder;
import su.artix.yuki.discount.condition.domain.xml.ConditionType;
import su.artix.yuki.discount.condition.template.dao.ConditionTemplateDAO;

public class ConditionTemplateXmlFileDAO
implements ConditionTemplateDAO {
    private static final Logger log = LoggerFactory.getLogger(ConditionTemplateXmlFileDAO.class);
    private Unmarshaller unmarshaller;
    private Unmarshaller tagsUnmarshaller;
    private Marshaller marshaller;
    private String templatesPackagePath;
    private String templatesPath;
    private String tagsPackagePath;
    private String tagsPath;
    private String customeTemplatesPath;

    public ConditionTemplateXmlFileDAO(String templatesPackagePath, String templatesPath, String tagsPackagePath, String tagsPath, String customeTemplatesPath) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ConditionTemplatesHolder.class});
        this.unmarshaller = context.createUnmarshaller();
        this.tagsUnmarshaller = JAXBContext.newInstance((Class[])new Class[]{ConditionTemplateTagHolder.class}).createUnmarshaller();
        this.marshaller = context.createMarshaller();
        this.marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        this.templatesPackagePath = templatesPackagePath;
        this.templatesPath = templatesPath;
        this.tagsPackagePath = tagsPackagePath;
        this.tagsPath = tagsPath;
        this.customeTemplatesPath = customeTemplatesPath;
    }

    private InputStream getTemplates() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String[] variants = new String[]{this.templatesPackagePath, this.templatesPath};
        InputStream input = null;
        String[] stringArray = variants;
        int n = variants.length;
        int n2 = 0;
        while (n2 < n) {
            String variant = stringArray[n2];
            input = classLoader.getResourceAsStream(variant);
            if (input != null) break;
            ++n2;
        }
        return input;
    }

    private InputStream getTags() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String[] variants = new String[]{this.tagsPackagePath, this.tagsPath};
        InputStream input = null;
        String[] stringArray = variants;
        int n = variants.length;
        int n2 = 0;
        while (n2 < n) {
            String variant = stringArray[n2];
            input = classLoader.getResourceAsStream(variant);
            if (input != null) break;
            ++n2;
        }
        return input;
    }

    @Override
    public List<ConditionTemplate> getTemplateList() {
        ConditionTemplatesHolder holder = new ConditionTemplatesHolder();
        if (this.customeTemplatesPath != null && !this.customeTemplatesPath.isEmpty()) {
            try {
                URL url = new URL(Platform.getInstallLocation().getURL() + this.customeTemplatesPath);
                File file = new File(url.getFile());
                if (file.exists()) {
                    ConditionTemplatesHolder customHolder = (ConditionTemplatesHolder)this.unmarshaller.unmarshal(file);
                    for (ConditionTemplate template : customHolder.getTemplates()) {
                        if (template.getTags() != null && template.getTags().contains("card")) {
                            template.setType(ConditionType.CARD);
                            continue;
                        }
                        if (template.getTags() != null && template.getTags().contains("coupon")) {
                            template.setType(ConditionType.COUPON);
                            continue;
                        }
                        template.setType(ConditionType.COMMON);
                    }
                    holder.addTemplateAll(customHolder.getTemplates());
                }
            }
            catch (JAXBException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (MalformedURLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (holder.getTemplates().isEmpty()) {
            holder.addTemplateAll(this.getDefaultTemplateList());
            this.saveAll(holder.getTemplates());
        }
        return holder.getTemplates();
    }

    public List<ConditionTemplate> getTemplateList(InputStream stream) {
        ConditionTemplatesHolder holder = null;
        if (stream != null) {
            try {
                holder = (ConditionTemplatesHolder)this.unmarshaller.unmarshal(stream);
            }
            catch (JAXBException e) {
                holder = new ConditionTemplatesHolder();
                holder.setTemplates(new ArrayList<ConditionTemplate>());
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            holder = new ConditionTemplatesHolder();
            holder.setTemplates(new ArrayList<ConditionTemplate>());
        }
        if (this.customeTemplatesPath != null && !this.customeTemplatesPath.isEmpty()) {
            ConditionTemplatesHolder customHolder = null;
            try {
                URL url = new URL(Platform.getInstallLocation().getURL() + this.customeTemplatesPath);
                File file = new File(url.getFile());
                customHolder = (ConditionTemplatesHolder)this.unmarshaller.unmarshal(file);
            }
            catch (JAXBException jAXBException) {
                customHolder = new ConditionTemplatesHolder();
                customHolder.setTemplates(new ArrayList<ConditionTemplate>());
            }
            catch (MalformedURLException malformedURLException) {
                customHolder = new ConditionTemplatesHolder();
                customHolder.setTemplates(new ArrayList<ConditionTemplate>());
            }
            if (customHolder.getTemplates() != null) {
                holder.getTemplates().addAll(customHolder.getTemplates());
            }
        }
        for (ConditionTemplate template : holder.getTemplates()) {
            if (template.getTags() != null && template.getTags().contains("card")) {
                template.setType(ConditionType.CARD);
                continue;
            }
            template.setType(ConditionType.COMMON);
        }
        return holder.getTemplates();
    }

    @Override
    public int getTemplateCount() {
        return this.getTemplateList().size();
    }

    @Override
    public ConditionTemplate getTemplate(Integer order) {
        for (ConditionTemplate template : this.getTemplateList()) {
            if (template.getOrder() != order) continue;
            return template;
        }
        return null;
    }

    @Override
    public void addTemplate(ConditionTemplate template) {
        List<ConditionTemplate> list = this.getTemplateList();
        int order = this.getMaxOrder(list) + 1;
        template.setOrder(order);
        list.add(template);
        this.saveAll(list);
    }

    @Override
    public void saveTemplate(ConditionTemplate template) {
        List<ConditionTemplate> list = this.getTemplateList();
        int i = 0;
        while (i < list.size()) {
            ConditionTemplate item = list.get(i);
            if (item.getOrder().equals(template.getOrder())) {
                if (!item.equals(template)) {
                    list.set(i, template);
                }
                this.saveAll(list);
                break;
            }
            ++i;
        }
    }

    @Override
    public void deleteTemplate(ConditionTemplate template) {
        if (template != null) {
            List<ConditionTemplate> list = this.getTemplateList();
            Iterator<ConditionTemplate> iter = list.iterator();
            while (iter.hasNext()) {
                if (iter.next().getOrder() != template.getOrder()) continue;
                iter.remove();
                break;
            }
            this.saveAll(list);
        }
    }

    @Override
    public void saveAll(List<ConditionTemplate> allTemplateList) {
        if (allTemplateList != null) {
            try {
                URL url = new URL(Platform.getInstallLocation().getURL() + this.customeTemplatesPath);
                File file = new File(url.getFile());
                if (!allTemplateList.isEmpty()) {
                    ConditionTemplatesHolder holder = new ConditionTemplatesHolder();
                    holder.setTemplates(allTemplateList);
                    try {
                        this.marshaller.marshal((Object)holder, file);
                    }
                    catch (JAXBException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (MalformedURLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void updateAll(List<ConditionTemplate> templateList) {
        List<ConditionTemplate> list = this.getTemplateList();
        ArrayList<ConditionTemplate> tempList = new ArrayList<ConditionTemplate>(templateList);
        for (ConditionTemplate conditionTemplate : templateList) {
            if (!list.contains(conditionTemplate)) continue;
            tempList.remove(conditionTemplate);
        }
        for (ConditionTemplate conditionTemplate : tempList) {
            int index = this.findTemplateByOrder(list, conditionTemplate.getOrder());
            if (index == -1) continue;
            list.remove(index);
        }
        list.addAll(tempList);
        this.saveAll(list);
    }

    @Override
    public List<ConditionTemplateTag> getTemplateTags() {
        return this.getTemplateTags(this.getTags());
    }

    public List<ConditionTemplateTag> getTemplateTags(InputStream stream) {
        ConditionTemplateTagHolder holder = null;
        if (stream != null) {
            try {
                holder = (ConditionTemplateTagHolder)this.tagsUnmarshaller.unmarshal(stream);
            }
            catch (JAXBException jAXBException) {
                holder = new ConditionTemplateTagHolder();
                holder.setTags(new ArrayList<ConditionTemplateTag>());
            }
        } else {
            holder = new ConditionTemplateTagHolder();
            holder.setTags(new ArrayList<ConditionTemplateTag>());
        }
        return holder.getTags();
    }

    @Override
    public List<ConditionTemplate> filterTemplatesByTag(String tag) {
        List<ConditionTemplate> list = this.getTemplateList();
        ArrayList<ConditionTemplate> newList = new ArrayList<ConditionTemplate>();
        for (ConditionTemplate template : list) {
            if (template.getTags() == null || !template.getTags().contains(tag)) continue;
            newList.add(template);
        }
        return newList;
    }

    public Integer getMaxOrder() {
        return this.getMaxOrder(this.getTemplateList());
    }

    public Integer getMaxOrder(List<ConditionTemplate> list) {
        int maxOrder = 0;
        for (ConditionTemplate conditionTemplate : list) {
            if (conditionTemplate.getOrder() <= maxOrder) continue;
            maxOrder = conditionTemplate.getOrder();
        }
        return maxOrder;
    }

    private Integer findTemplateByOrder(List<ConditionTemplate> list, Integer order) {
        Integer index = -1;
        for (ConditionTemplate conditionTemplate : list) {
            if (!conditionTemplate.getOrder().equals(order)) continue;
            index = list.indexOf(conditionTemplate);
            break;
        }
        return index;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public Unmarshaller getTagsUnmarshaller() {
        return this.tagsUnmarshaller;
    }

    public void setTagsUnmarshaller(Unmarshaller tagsUnmarshaller) {
        this.tagsUnmarshaller = tagsUnmarshaller;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public List<ConditionTemplate> getDefaultTemplateList() {
        InputStream stream = this.getTemplates();
        if (stream != null) {
            try {
                ConditionTemplatesHolder holder = (ConditionTemplatesHolder)this.unmarshaller.unmarshal(stream);
                for (ConditionTemplate template : holder.getTemplates()) {
                    if (template.getTags() != null && template.getTags().contains("card")) {
                        template.setType(ConditionType.CARD);
                        continue;
                    }
                    template.setType(ConditionType.COMMON);
                }
                return holder.getTemplates();
            }
            catch (JAXBException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<ConditionTemplate>();
    }

    @Override
    public void restoreDefaultTemplate() {
        ConditionTemplatesHolder holder = new ConditionTemplatesHolder();
        holder.addTemplateAll(this.getTemplateList());
        holder.addTemplateAll(this.getDefaultTemplateList());
        this.saveAll(holder.getTemplates());
    }
}

