/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.action.DirectoryAddAction;
import su.artix.yuki.action.DirectoryCopyAction;
import su.artix.yuki.action.DirectoryEditAction;
import su.artix.yuki.action.DirectoryRefreshAction;
import su.artix.yuki.action.DirectoryRemoveAction;

public class DirectoryEditActionGroup<E>
extends ActionGroup {
    protected final Class<E> clazz;
    @SecurityKey(title="\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c")
    protected DirectoryAddAction<E> addAction;
    @SecurityKey(title="\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c")
    protected IAction editAction;
    @SecurityKey(title="\u0423\u0434\u0430\u043b\u0438\u0442\u044c")
    protected IAction removeAction;
    @SecurityKey(title="\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c")
    protected IAction refreshAction;
    @SecurityKey(title="\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c")
    protected IAction copyAction;
    private List<IAction> customActions = new ArrayList<IAction>();
    private Set<String> removed = new HashSet<String>();

    public DirectoryEditActionGroup(Class<E> cl) {
        this.clazz = cl;
    }

    public DirectoryEditActionGroup(Class<E> cl, List<IAction> customActions) {
        this(cl);
        this.customActions = customActions;
    }

    public DirectoryEditActionGroup<E> removeAction(String ... actionId) {
        this.removed.addAll(Arrays.asList(actionId));
        return this;
    }

    protected void makeActions() {
        if (!this.removed.contains("ru.ssa.artixadmin.action.DirectoryAddAction")) {
            this.addAction = this.createAddAction(this.clazz);
        }
        if (!this.removed.contains("ru.ssa.artixadmin.action.DirectoryEditAction")) {
            this.editAction = this.createEditAction(this.clazz);
        }
        if (!this.removed.contains("ru.ssa.artixadmin.action.DirectoryRemoveAction")) {
            this.removeAction = this.createRemoveAction(this.clazz);
        }
        if (!this.removed.contains("ru.ssa.artixadmin.action.DirectoryRefreshAction")) {
            this.refreshAction = new DirectoryRefreshAction<E>(this.clazz);
            this.refreshAction.setAccelerator(262226);
        }
        if (!this.removed.contains("ru.ssa.artixadmin.action.DirectoryCopyAction")) {
            this.copyAction = new DirectoryCopyAction<E>(this.clazz);
        }
    }

    protected DirectoryAddAction<E> createAddAction(Class<E> e) {
        return new DirectoryAddAction<E>(this.clazz);
    }

    protected IAction createEditAction(Class<E> e) {
        return new DirectoryEditAction<E>(e);
    }

    protected IAction createRemoveAction(Class<E> e) {
        return new DirectoryRemoveAction<E>(e);
    }

    protected void fillToolBar(IToolBarManager toolBar) {
        if (this.customActions != null) {
            for (IAction action : this.customActions) {
                toolBar.add(action);
            }
            toolBar.add((IContributionItem)new Separator());
        }
        if (this.refreshAction != null) {
            toolBar.add(this.refreshAction);
        }
        if (this.addAction != null) {
            toolBar.add(this.addAction);
        }
        if (this.editAction != null) {
            toolBar.add(this.editAction);
        }
        if (this.removeAction != null) {
            toolBar.add(this.removeAction);
        }
        if (this.copyAction != null) {
            toolBar.add(this.copyAction);
        }
    }

    protected void fillViewMenu(IMenuManager menu) {
        if (this.customActions != null) {
            for (IAction action : this.customActions) {
                menu.add(action);
            }
            menu.add((IContributionItem)new Separator());
        }
        if (this.refreshAction != null) {
            menu.add(this.refreshAction);
        }
        if (this.addAction != null) {
            menu.add(this.addAction);
        }
        if (this.editAction != null) {
            menu.add(this.editAction);
        }
        if (this.removeAction != null) {
            menu.add(this.removeAction);
        }
        if (this.copyAction != null) {
            menu.add(this.copyAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        this.makeActions();
        this.fillToolBar(actionBars.getToolBarManager());
        this.fillViewMenu(actionBars.getMenuManager());
    }

    public DirectoryAddAction<E> getAddAction() {
        return this.addAction;
    }

    public void setEnabledAllGroupActions(Boolean isEnabled) {
        if (this.refreshAction != null) {
            this.refreshAction.setEnabled(isEnabled.booleanValue());
        }
        if (this.addAction != null) {
            this.addAction.setEnabled(isEnabled);
        }
        if (this.editAction != null) {
            this.editAction.setEnabled(isEnabled.booleanValue());
        }
        if (this.removeAction != null) {
            this.removeAction.setEnabled(isEnabled.booleanValue());
        }
        if (this.copyAction != null) {
            this.copyAction.setEnabled(isEnabled.booleanValue());
        }
    }

    public void setEnabledEditGroupActions(Boolean isEnabled) {
        if (this.editAction != null) {
            this.editAction.setEnabled(isEnabled.booleanValue());
        }
        if (this.removeAction != null) {
            this.removeAction.setEnabled(isEnabled.booleanValue());
        }
        if (this.addAction != null) {
            this.addAction.setEnabled(isEnabled);
        }
        if (this.copyAction != null) {
            this.copyAction.setEnabled(isEnabled.booleanValue());
        }
    }

    public void setEnabledRefreshAction(Boolean isEnabled) {
        if (this.refreshAction != null) {
            this.refreshAction.setEnabled(isEnabled.booleanValue());
        }
    }

    public void setEnabledAddAction(Boolean isEnabled) {
        if (this.addAction != null) {
            this.addAction.setEnabled(isEnabled);
        }
    }

    public void setEnabledRemoveAction(Boolean isEnabled) {
        if (this.removeAction != null) {
            this.removeAction.setEnabled(isEnabled.booleanValue());
        }
    }

    public void dispose() {
        super.dispose();
        if (this.editAction != null) {
            ((ActionFactory.IWorkbenchAction)this.editAction).dispose();
        }
        if (this.removeAction != null) {
            ((ActionFactory.IWorkbenchAction)this.removeAction).dispose();
        }
        if (this.copyAction != null) {
            ((ActionFactory.IWorkbenchAction)this.copyAction).dispose();
        }
    }

    public Class<E> getClazz() {
        return this.clazz;
    }
}

