/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.action;

import com.rits.cloning.Cloner;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.yuki.action.IModel;
import su.artix.yuki.editors.AbstractDirectorySelectDialog;
import su.artix.yuki.editors.CustomValidateSelection;
import su.artix.yuki.editors.DirectorySelectDialogState;
import su.artix.yuki.editors.DirectorySelectFactory;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.model.DuplicateValueException;
import su.artix.yuki.model.directory.DirectoryEditModelStub;

public class TableViewerSelectAction<E>
extends Action
implements IModel {
    private static final Logger log = LoggerFactory.getLogger(TableViewerSelectAction.class);
    private final Class<E> cl;
    private final PropertyChangeListener propertyChangeListener;
    private Object model;
    private CustomValidateSelection selectionValidator;

    public TableViewerSelectAction(Class<E> cl, PropertyChangeListener propertyChangeListener) {
        super("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c");
        this.cl = cl;
        this.propertyChangeListener = propertyChangeListener;
        this.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/add"));
        this.setToolTipText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
    }

    public void run() {
        AbstractDirectorySelectDialog<Object, ?> dialog = DirectorySelectFactory.getSelect(this.cl, Display.getDefault().getActiveShell(), this.model, new DirectorySelectDialogState());
        dialog.setSelectionValidator(this.selectionValidator);
        DirectoryEditModelStub model = new DirectoryEditModelStub();
        model.addPropertyChangeListener(this.propertyChangeListener);
        dialog.open();
        Object retmodel = dialog.getModel();
        if (retmodel != null && dialog.getReturnCode() != 1) {
            try {
                model.doAdd(retmodel);
            }
            catch (DuplicateValueException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (ExecuteQueryException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public Object getModel() {
        return this.model;
    }

    @Override
    public void setModel(Object model) {
        try {
            this.model = new Cloner().deepClone(model);
        }
        catch (Exception e) {
            log.error("Couldn't clone.", (Throwable)e);
        }
        log.trace("");
    }

    public CustomValidateSelection getSelectionValidator() {
        return this.selectionValidator;
    }

    public void setSelectionValidator(CustomValidateSelection selectionValidator) {
        this.selectionValidator = selectionValidator;
    }
}

