/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.ArtixAdminActivator;
import ru.ssa.artixadmin.view.DisplayElementDBVersion;
import ru.ssa.artixadmin.view.PerspectiveExplorerCategories;
import ru.ssa.cashadmin.LibActivator;
import su.artix.cashserver.security.GuiElementController;
import su.artix.discountmanager.Activator;
import su.artix.yuki.directory.GuiActivator;
import su.artix.yuki.images.ArtixAdminImages;

public class PerspectiveExplorerView
extends ViewPart {
    private static Logger log = LoggerFactory.getLogger(PerspectiveExplorerView.class);
    private ExpandBar expandBar;
    private IMemento memento;
    private List<Button> buttons = new ArrayList<Button>();

    private void createExpandElement(final ExpandBar expandBar, String nameCategory, Collection<DisplayElementDBVersion> category, Image image) {
        Composite composite = new Composite((Composite)expandBar, 0);
        GridLayoutFactory.swtDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        boolean hasElements = false;
        boolean cashServerMode = ArtixAdminActivator.getDefault().isCashServer();
        GuiElementController elementController = (GuiElementController)GuiActivator.getDefault().getBeanByClass(GuiElementController.class);
        for (DisplayElementDBVersion element : category) {
            IPerspectiveDescriptor perspectiveDescriptor = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(element.getId());
            if (!elementController.hasRightsPerspective(perspectiveDescriptor.getId())) continue;
            Button button = new Button(composite, 2);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)button);
            button.setAlignment(16384);
            button.setText(perspectiveDescriptor.getLabel());
            button.setImage(perspectiveDescriptor.getImageDescriptor().createImage());
            button.setData((Object)perspectiveDescriptor);
            button.setData("server", (Object)(element.getMode() != DisplayElementDBVersion.ViewMode.CASH ? 1 : 0));
            button.setData("cash", (Object)(element.getMode() != DisplayElementDBVersion.ViewMode.SERVER ? 1 : 0));
            if (element.getDBType() == DisplayElementDBVersion.DBType.DICTIONARY) {
                button.setData("dbVersionValid", (Object)(element.getDBVersion() <= LibActivator.getDefault().getDictionaryVersion() ? 1 : 0));
            } else if (element.getDBType() == DisplayElementDBVersion.DBType.DOCUMENT) {
                button.setData("dbVersionValid", (Object)(element.getDBVersion() <= LibActivator.getDefault().getDocumentVersion() ? 1 : 0));
            } else {
                button.setData("dbVersionValid", (Object)true);
            }
            if (cashServerMode || element.getMode() != DisplayElementDBVersion.ViewMode.SERVER) {
                hasElements = true;
            }
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IPerspectiveDescriptor perspectiveDescriptor = (IPerspectiveDescriptor)((Button)e.widget).getData();
                    String id = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId();
                    if (!id.equals(perspectiveDescriptor.getId()) && (id.startsWith("su.artix.discountmanager.perspective") || id.startsWith("su.artix.discountmanager.perspectives.bonus")) && !Activator.getDefault().saveDiscountSystems()) {
                        e.doit = false;
                        ((Button)e.widget).setSelection(false);
                        return;
                    }
                    if (!id.equals(perspectiveDescriptor.getId()) && ("ru.ssa.artixadmin.perspectives.DocumentsPerspective".equals(perspectiveDescriptor.getId()) || "ru.ssa.artixadmin.perspectives.CrightsPerspective".equals(perspectiveDescriptor.getId())) && ArtixAdminActivator.getDefault().getSelectedCategory() != null) {
                        final String btnTitle = ((Button)e.widget).getText();
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                String title = ArtixAdminActivator.getDefault().getSelectedCategory().getTitle();
                                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", (String)("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432 \u043d\u0435 \u043f\u0440\u0435\u0434\u043f\u043e\u043b\u0430\u0433\u0430\u044e\u0442 \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432, \u043f\u043e\u044d\u0442\u043e\u043c\u0443 \u0432\u044b\u0431\u043e\u0440 \u043f\u0443\u043d\u043a\u0442\u0430 \u043c\u0435\u043d\u044e: \"" + btnTitle + "\" \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d. \n\n\u0415\u0441\u043b\u0438 \u0412\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u043f\u0435\u0440\u0435\u0439\u0442\u0438 \u0432 \u043c\u0435\u043d\u044e: \"\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b\", \u0438\u043b\u0438 \"\u0416\u0443\u0440\u043d\u0430\u043b \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439\", \u0442\u043e \u0441\u043d\u0438\u043c\u0438\u0442\u0435 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0441 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438: \"" + title + "\"."));
                            }
                        });
                        e.doit = false;
                        ((Button)e.widget).setSelection(false);
                        return;
                    }
                    Control[] controlArray = expandBar.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        if (control instanceof Composite) {
                            Control[] controlArray2 = ((Composite)control).getChildren();
                            int n3 = controlArray2.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Control child = controlArray2[n4];
                                if (e.widget != child && child instanceof Button && (child.getStyle() & 2) != 0) {
                                    ((Button)child).setSelection(false);
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                    ((Button)e.widget).setSelection(true);
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().setPerspective(perspectiveDescriptor);
                    try {
                        if (perspectiveDescriptor.getId().equals("su.artix.discountmanager.perspective") || perspectiveDescriptor.getId().equals("su.artix.discountmanager.perspectivemulti")) {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("su.artix.discountmanager.views.discountsystemview").setFocus();
                        } else if (perspectiveDescriptor.getId().equals("su.artix.discountmanager.perspectives.bonus") || perspectiveDescriptor.getId().equals("su.artix.discountmanager.perspectives.bonusmulti")) {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("su.artix.discountmanager.views.earnview").setFocus();
                        }
                    }
                    catch (PartInitException exception) {
                        log.error("Exception perspective change: {}", (Throwable)exception);
                    }
                }
            });
            this.buttons.add(button);
        }
        if (hasElements) {
            ExpandItem expandItem = new ExpandItem(expandBar, 0);
            expandItem.setText(nameCategory);
            expandItem.setHeight(composite.computeSize((int)-1, (int)-1).y);
            expandItem.setControl((Control)composite);
            if (image != null) {
                expandItem.setImage(image);
            }
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void createPartControl(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.expandBar = new ExpandBar(parent, 512);
        this.expandBar.setSpacing(5);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.expandBar);
        PerspectiveExplorerCategories.init(ArtixAdminActivator.getDefault().isCashServer());
        this.createExpandElement(this.expandBar, "\u0421\u0435\u0440\u0432\u0438\u0441", PerspectiveExplorerCategories.serviceCategory, ArtixAdminImages.getDefault().getImage("plane/24x24/service"));
        this.createExpandElement(this.expandBar, "\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438", PerspectiveExplorerCategories.directoryCategory, ArtixAdminImages.getDefault().getImage("plane/24x24/dict"));
        this.createExpandElement(this.expandBar, "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b", PerspectiveExplorerCategories.documentsCategory, ArtixAdminImages.getDefault().getImage("plane/24x24/document"));
        this.createExpandElement(this.expandBar, "\u041a\u0430\u0440\u0442\u044b \u0438 \u0433\u0440\u0443\u043f\u043f\u044b", PerspectiveExplorerCategories.cardsCategory, ArtixAdminImages.getDefault().getImage("plane/24x24/groups"));
        this.createExpandElement(this.expandBar, "\u0421\u043a\u0438\u0434\u043a\u0438", PerspectiveExplorerCategories.discountCategory, ArtixAdminImages.getDefault().getImage("plane/24x24/discount"));
        this.createExpandElement(this.expandBar, "\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439", PerspectiveExplorerCategories.auditCategory, ArtixAdminImages.getDefault().getImage("plane/24x24/audit"));
        this.createExpandElement(this.expandBar, "\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435", PerspectiveExplorerCategories.administrationCategory, ArtixAdminImages.getDefault().getImage("plane/24x24/administration"));
        if (this.memento != null) {
            this.restoreState();
        }
        this.applyRights();
    }

    public void applyRights() {
        this.applyRights(Activator.getDefault().getPreferenceStore().getBoolean("VISIBLE_DICTIONARY_PICKLIST_PERSPECTIVE"));
    }

    public void applyRights(boolean isVisiblePicklistPerspective) {
        ((GuiElementController)GuiActivator.getDefault().getBeanByClass(GuiElementController.class)).applyRightsPerspective(this.buttons, ArtixAdminActivator.getDefault().isCashServer(), isVisiblePicklistPerspective);
        ExpandItem[] expandItemArray = this.expandBar.getItems();
        int n = expandItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExpandItem item = expandItemArray[n2];
            item.setHeight(item.getControl().computeSize((int)-1, (int)-1).y);
            item.getControl().pack();
            ++n2;
        }
    }

    private void restoreState() {
        int n;
        String selectedNode;
        IMemento selectionsMomento = this.memento.getChild("selections");
        if (selectionsMomento != null && (selectedNode = selectionsMomento.getString("selected-button")) != null) {
            Control[] controlArray = this.expandBar.getChildren();
            int n2 = controlArray.length;
            n = 0;
            while (n < n2) {
                Control control = controlArray[n];
                if (control instanceof Composite) {
                    Control[] controlArray2 = ((Composite)control).getChildren();
                    int n3 = controlArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Control child = controlArray2[n4];
                        if (child instanceof Button && (child.getStyle() & 2) != 0 && selectedNode.equals(((Button)child).getText())) {
                            ((Button)child).setSelection(true);
                        }
                        ++n4;
                    }
                }
                ++n;
            }
        }
        if (selectionsMomento != null) {
            ExpandItem[] expandItemArray = this.expandBar.getItems();
            n = expandItemArray.length;
            int n5 = 0;
            while (n5 < n) {
                ExpandItem expandItem = expandItemArray[n5];
                if (selectionsMomento.getString(expandItem.getText()) != null) {
                    expandItem.setExpanded(true);
                }
                ++n5;
            }
        }
    }

    public void resetState() {
        ExpandItem[] expandItemArray = this.expandBar.getItems();
        int n = expandItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExpandItem expandItem = expandItemArray[n2];
            expandItem.setExpanded(false);
            ++n2;
        }
        expandItemArray = this.expandBar.getChildren();
        n = expandItemArray.length;
        n2 = 0;
        while (n2 < n) {
            ExpandItem control = expandItemArray[n2];
            if (control instanceof Composite) {
                Control[] controlArray = ((Composite)control).getChildren();
                int n3 = controlArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Control child = controlArray[n4];
                    if (child instanceof Button && (child.getStyle() & 2) != 0) {
                        ((Button)child).setSelection(false);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void saveState(IMemento memento) {
        memento = memento.createChild("selections");
        Control[] controlArray = this.expandBar.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                Control[] controlArray2 = ((Composite)control).getChildren();
                int n3 = controlArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Control child = controlArray2[n4];
                    if (child instanceof Button && (child.getStyle() & 2) != 0 && ((Button)child).getSelection()) {
                        memento.putString("selected-button", ((Button)child).getText());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        controlArray = this.expandBar.getItems();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            Control expandItem = controlArray[n2];
            if (expandItem.getExpanded()) {
                memento.putString(expandItem.getText().replaceAll(" ", ""), expandItem.getText().replaceAll(" ", ""));
            }
            ++n2;
        }
    }

    public void setFocus() {
    }

    public List<Button> getButtons() {
        return this.buttons;
    }
}

