/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import ru.ssa.artixadmin.Caller;
import ru.ssa.artixadmin.SecurityObjectManager;
import ru.ssa.artixadmin.view.DisplayElementDBVersion;
import ru.ssa.artixadmin.view.PerspectiveExplorerCategories;
import su.artix.cashserver.core.cashregistry.domain.SecurityObject;
import su.artix.cashserver.core.cashregistry.repository.SecurityObjectRepository;
import su.artix.cashserver.security.ParentSecurityKey;
import su.artix.cashserver.security.SecurityKey;
import su.artix.discountmanager.views.BonusView;
import su.artix.yuki.action.DirectoryExportActionGroup;
import su.artix.yuki.editors.DirectorySelectDialog;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.view.DirectoryView;

public class SecurityObjectManagerImpl
implements SecurityObjectManager {
    private static final Logger log = LoggerFactory.getLogger(SecurityObjectManagerImpl.class);
    @Autowired
    private SecurityObjectRepository securityObjectRepository;
    private Map<String, SecurityObject> securityObjectParentClasses = new HashMap<String, SecurityObject>();

    @Override
    public void persistAddSecurityObjects(Caller monitor) {
        AtomicInteger current = new AtomicInteger();
        this.persist(true, current, monitor);
        this.persist(false, current, monitor);
        this.writeSecurityObjectsPerspective(current, monitor);
    }

    private void persist(boolean parent, AtomicInteger current, Caller monitor) {
        this.writeSecurityObjects(Platform.getBundle((String)"su.artix.discountmanager"), "su.artix.discountmanager.dialogs", 0, parent, current, monitor);
        this.writeSecurityObjects(Platform.getBundle((String)"su.artix.discountmanager"), "target/classes/su.artix.discountmanager.dialogs", 15, parent, current, monitor);
        this.writeSecurityObjects(Platform.getBundle((String)"su.artix.cashadmin"), "ru.ssa.artixadmin.editors", 0, parent, current, monitor);
        this.writeSecurityObjects(Platform.getBundle((String)"su.artix.cashadmin"), "target/classes/ru.ssa.artixadmin.editors", 15, parent, current, monitor);
        this.writeSecurityObjects(Platform.getBundle((String)"su.artix.cashadmin"), "ru.ssa.artixadmin.view", 0, parent, current, monitor);
        this.writeSecurityObjects(Platform.getBundle((String)"su.artix.cashadmin"), "target/classes/ru.ssa.artixadmin.view", 15, parent, current, monitor);
        this.writeSecurityObjects(Platform.getBundle((String)"su.artix.discountmanager"), "su.artix.discountmanager.views", 0, parent, current, monitor);
        this.writeSecurityObjects(Platform.getBundle((String)"su.artix.discountmanager"), "target/classes/su.artix.discountmanager.views", 15, parent, current, monitor);
    }

    private void writeSecurityObjectsPerspective(AtomicInteger current, Caller monitor) {
        ArrayList<SecurityObject> securityObjects = new ArrayList<SecurityObject>();
        SecurityObject securityObjectPerspectiveParent = new SecurityObject(PerspectiveExplorerCategories.class.getName());
        securityObjectPerspectiveParent.setTitle("\u041a\u043d\u043e\u043f\u043a\u0438 \u043c\u0435\u043d\u044e");
        securityObjects.add(securityObjectPerspectiveParent);
        for (DisplayElementDBVersion element : PerspectiveExplorerCategories.allCategories) {
            SecurityObject securityObjectPerspective = new SecurityObject(element.getId());
            securityObjectPerspective.setTitle(PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(element.getId()).getLabel());
            securityObjectPerspective.setParent(securityObjectPerspectiveParent);
            securityObjects.add(securityObjectPerspective);
        }
        this.saveSecurityObject(securityObjects, current, monitor);
    }

    private void saveSecurityObject(List<SecurityObject> securityObjects, AtomicInteger current, Caller monitor) {
        for (SecurityObject object : securityObjects) {
            this.securityObjectRepository.save((Object)object);
            monitor.worked(current.incrementAndGet());
        }
    }

    private void writeSecurityObjects(Bundle bundle, String packageName, int index, boolean haveParent, AtomicInteger current, Caller monitor) {
        ArrayList<SecurityObject> securityObjects = new ArrayList<SecurityObject>();
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        Collection resources = wiring.listResources(packageName.replace('.', '/'), "*.class", 1);
        for (String resource : resources) {
            resource = resource.replace('/', '.').substring(index, resource.length() - 6);
            Class clazz = null;
            try {
                clazz = bundle.loadClass(resource);
                Class<?> parentClazz = this.getParentClass(clazz);
                if (parentClazz == null || Modifier.isAbstract(clazz.getModifiers()) || !this.haveParent(clazz, haveParent)) continue;
                log.trace("class={}", (Object)clazz);
                SecurityObject securityObjectClass = this.createClassSecurityObject(clazz, this.createParentClassSecurityObject(clazz, parentClazz));
                securityObjects.add(securityObjectClass);
                this.visitField("", securityObjects, clazz, securityObjectClass);
                if (!DirectoryView.class.isAssignableFrom(clazz)) continue;
                this.visitField(clazz.getName(), securityObjects, DirectoryExportActionGroup.class, securityObjectClass);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        this.saveSecurityObject(securityObjects, current, monitor);
    }

    private boolean haveParent(Class<?> clazz, boolean paranted) {
        if (paranted) {
            return clazz.isAnnotationPresent(ParentSecurityKey.class);
        }
        return !clazz.isAnnotationPresent(ParentSecurityKey.class);
    }

    private Class<?> getParentClass(Class<?> clazz) {
        if (clazz != null && clazz.getSuperclass() != null) {
            if (EditorComposite.class.isAssignableFrom(clazz)) {
                return EditorComposite.class;
            }
            if (DirectoryView.class.isAssignableFrom(clazz)) {
                return DirectoryView.class;
            }
            if (BonusView.class.isAssignableFrom(clazz)) {
                return DirectoryView.class;
            }
            if (DirectorySelectDialog.class.isAssignableFrom(clazz)) {
                return DirectorySelectDialog.class;
            }
        }
        return null;
    }

    public void visitField(String prefix, List<SecurityObject> securityObjects, Class<?> clazz, SecurityObject securityObjectClass) {
        log.info("CLASS_NAME = " + clazz.getName());
        PropertyDescriptor[] propertyDescriptorArray = PropertyUtils.getPropertyDescriptors(clazz);
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field;
            PropertyDescriptor descriptor = propertyDescriptorArray[n2];
            log.trace("work with field:{},type:{}", (Object)descriptor.getName(), descriptor.getPropertyType());
            if (this.isValidField(descriptor.getPropertyType()) && this.isValidName(descriptor.getName()) && (field = FieldUtils.getField(clazz, (String)descriptor.getName(), (boolean)true)) != null && !this.isIgnore(field)) {
                SecurityObject securityObjectField = this.createFieldSecurityObject(prefix, clazz, field);
                securityObjectField.setParent(securityObjectClass);
                if (!securityObjects.contains(securityObjectField)) {
                    securityObjects.add(securityObjectField);
                }
            }
            ++n2;
        }
        this.visitFieldOfClass(prefix, securityObjects, clazz, securityObjectClass);
        if (clazz.getSuperclass() != null) {
            this.visitFieldOfParentClass(prefix, securityObjects, clazz, securityObjectClass);
        }
    }

    private boolean isIgnore(Field field) {
        if (field.isAnnotationPresent(SecurityKey.class)) {
            SecurityKey ann = field.getAnnotation(SecurityKey.class);
            return ann.ignore();
        }
        return false;
    }

    private boolean isValidName(String name) {
        return !"shell".equals(name) && !"parent".equals(name);
    }

    private void visitFieldOfClass(String prefix, List<SecurityObject> securityObjects, Class<?> clazz, SecurityObject securityObjectClass) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field;
            Field f = fieldArray[n2];
            log.trace("work with field:{},type:{}", (Object)f.getName(), f.getType());
            if (this.isValidField(f.getType()) && (field = FieldUtils.getField(clazz, (String)f.getName(), (boolean)true)) != null && !this.isIgnore(field)) {
                SecurityObject securityObjectField = this.createFieldSecurityObject(prefix, clazz, field);
                securityObjectField.setParent(securityObjectClass);
                if (!securityObjects.contains(securityObjectField)) {
                    securityObjects.add(securityObjectField);
                }
            }
            ++n2;
        }
    }

    private void visitFieldOfParentClass(String prefix, List<SecurityObject> securityObjects, Class<?> clazz, SecurityObject securityObjectClass) {
        Field[] fieldArray = clazz.getSuperclass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field;
            Field f = fieldArray[n2];
            log.trace("work with field:{},type:{}", (Object)f.getName(), f.getType());
            if (this.isValidField(f.getType()) && (field = FieldUtils.getField(clazz, (String)f.getName(), (boolean)true)) != null) {
                SecurityObject securityObjectField = this.createFieldSecurityObject(prefix, clazz, field);
                securityObjectField.setParent(securityObjectClass);
                if (!securityObjects.contains(securityObjectField)) {
                    securityObjects.add(securityObjectField);
                }
            }
            ++n2;
        }
    }

    private boolean isValidField(Class<?> f) {
        return f != null && (Control.class.isAssignableFrom(f) || f.equals(ComboViewer.class) || IAction.class.isAssignableFrom(f) || ActionGroup.class.isAssignableFrom(f));
    }

    private SecurityObject createFieldSecurityObject(String prefix, Class<?> clazz, Field f) {
        prefix = prefix.isEmpty() ? "" : String.valueOf(prefix) + ".";
        String id = String.valueOf(prefix) + clazz.getName() + "." + f.getName();
        String title = null;
        if (f.isAnnotationPresent(SecurityKey.class)) {
            SecurityKey ann = f.getAnnotation(SecurityKey.class);
            String annId = ann.id();
            if (annId != null && !annId.isEmpty()) {
                id = String.valueOf(prefix) + clazz.getName() + "." + annId;
            }
            title = ann.title();
        }
        if (clazz.equals(DirectoryExportActionGroup.class)) {
            id = id.replaceFirst(clazz.getName(), f.getDeclaringClass().getName());
        }
        SecurityObject securityObjectClass = new SecurityObject(id);
        securityObjectClass.setTitle(title);
        return securityObjectClass;
    }

    private SecurityObject createClassSecurityObject(Class<?> clazz, SecurityObject parent) {
        String id = clazz.getName();
        String title = null;
        if (clazz.isAnnotationPresent(SecurityKey.class)) {
            SecurityKey ann = clazz.getAnnotation(SecurityKey.class);
            String annId = ann.id();
            if (annId != null && !annId.isEmpty()) {
                id = annId;
            }
            title = ann.title();
        }
        SecurityObject securityObjectClass = new SecurityObject(id);
        securityObjectClass.setTitle(title);
        securityObjectClass.setParent(parent);
        return securityObjectClass;
    }

    private SecurityObject createParentClassSecurityObject(Class<?> clazz, Class<?> parent) {
        SecurityKey key;
        Class keyParent;
        SecurityObject securityObjectParentClass = null;
        if (clazz.isAnnotationPresent(SecurityKey.class) && !(keyParent = (key = clazz.getAnnotation(SecurityKey.class)).parent()).equals(Integer.class)) {
            securityObjectParentClass = this.securityObjectRepository.findById(keyParent.getName());
        }
        if (securityObjectParentClass == null) {
            if (this.securityObjectParentClasses.containsKey(parent.getName())) {
                securityObjectParentClass = this.securityObjectParentClasses.get(parent.getName());
            } else {
                securityObjectParentClass = this.filSecurityObjectParentClass(parent);
                this.securityObjectRepository.save((Object)securityObjectParentClass);
            }
            this.securityObjectParentClasses.put(parent.getName(), securityObjectParentClass);
        }
        return securityObjectParentClass;
    }

    private SecurityObject filSecurityObjectParentClass(Class<?> clazz) {
        SecurityObject securityObject = new SecurityObject(clazz.getName());
        String title = null;
        if (EditorComposite.class.isAssignableFrom(clazz)) {
            title = "\u041e\u043a\u043d\u0430 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f";
        } else if (DirectoryView.class.isAssignableFrom(clazz)) {
            title = "\u041e\u043a\u043d\u0430 \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430";
        } else if (DirectorySelectDialog.class.isAssignableFrom(clazz)) {
            title = "\u041e\u043a\u043d\u0430 \u0432\u044b\u0431\u043e\u0440\u0430";
        }
        securityObject.setTitle(title);
        return securityObject;
    }
}

