/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.itemSelector;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.mihalis.opal.itemSelector.DLItem;
import org.mihalis.opal.itemSelector.SelectionChangeEvent;
import org.mihalis.opal.itemSelector.SelectionChangeListener;
import org.mihalis.opal.utils.SWTGraphicUtil;
import org.mihalis.opal.utils.SimpleSelectionAdapter;

public class DualList
extends Composite {
    private static final String DOUBLE_DOWN_IMAGE = "double_down.png";
    private static final String DOUBLE_UP_IMAGE = "double_up.png";
    private static final String DOUBLE_LEFT_IMAGE = "double_left.png";
    private static final String DOUBLE_RIGHT_IMAGE = "double_right.png";
    private static final String ARROW_DOWN_IMAGE = "arrow_down.png";
    private static final String ARROW_LEFT_IMAGE = "arrow_left.png";
    private static final String ARROW_UP_IMAGE = "arrow_up.png";
    private static final String ARROW_RIGHT_IMAGE = "arrow_right.png";
    private final List<DLItem> items = new ArrayList<DLItem>();
    private final List<DLItem> selection = new ArrayList<DLItem>();
    private Table itemsTable;
    private Table selectionTable;
    private List<SelectionListener> selectionListeners;
    private List<SelectionChangeListener> selectionChangeListeners;

    public DualList(Composite composite, int n) {
        super(composite, n);
        this.setLayout((Layout)new GridLayout(4, false));
        this.createItemsTable();
        this.createButtonSelectAll();
        this.createSelectionTable();
        this.createButtonMoveFirst();
        this.createButtonSelect();
        this.createButtonMoveUp();
        this.createButtonDeselect();
        this.createButtonMoveDown();
        this.createButtonDeselectAll();
        this.createButtonMoveLast();
    }

    private void createItemsTable() {
        this.itemsTable = this.createTable();
        this.itemsTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                DualList.this.selectItem();
            }
        });
    }

    private Table createTable() {
        Table table = new Table((Composite)this, 66306);
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        GridData gridData = new GridData(4, 4, true, true, 1, 4);
        gridData.widthHint = 200;
        table.setLayoutData((Object)gridData);
        new TableColumn(table, 0x1000000);
        new TableColumn(table, 16384);
        table.setData((Object)-1);
        return table;
    }

    private void createButtonSelectAll() {
        Button button = this.createButton(DOUBLE_RIGHT_IMAGE, true, 3);
        button.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent selectionEvent) {
                DualList.this.selectAll();
            }
        });
    }

    private void createSelectionTable() {
        this.selectionTable = this.createTable();
        this.selectionTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                DualList.this.deselectItem();
            }
        });
    }

    private void createButtonMoveFirst() {
        Button button = this.createButton(DOUBLE_UP_IMAGE, true, 3);
        button.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent selectionEvent) {
                DualList.this.moveSelectionToFirstPosition();
            }
        });
    }

    private void createButtonSelect() {
        Button button = this.createButton(ARROW_RIGHT_IMAGE, false, 2);
        button.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent selectionEvent) {
                DualList.this.selectItem();
            }
        });
    }

    private void createButtonMoveUp() {
        Button button = this.createButton(ARROW_UP_IMAGE, false, 2);
        button.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent selectionEvent) {
                DualList.this.moveUpItem();
            }
        });
    }

    private void createButtonDeselect() {
        Button button = this.createButton(ARROW_LEFT_IMAGE, false, 2);
        button.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent selectionEvent) {
                DualList.this.deselectItem();
            }
        });
    }

    private void createButtonMoveDown() {
        Button button = this.createButton(ARROW_DOWN_IMAGE, false, 2);
        button.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent selectionEvent) {
                DualList.this.moveDownItem();
            }
        });
    }

    private void createButtonDeselectAll() {
        Button button = this.createButton(DOUBLE_LEFT_IMAGE, false, 1);
        button.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent selectionEvent) {
                DualList.this.deselectAll();
            }
        });
    }

    private void createButtonMoveLast() {
        Button button = this.createButton(DOUBLE_DOWN_IMAGE, true, 1);
        button.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent selectionEvent) {
                DualList.this.moveSelectionToLastPosition();
            }
        });
    }

    private Button createButton(String string, boolean bl, int n) {
        Button button = new Button((Composite)this, 8);
        Image image = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/" + string));
        button.setImage(image);
        button.setLayoutData((Object)new GridData(2, n, false, bl));
        SWTGraphicUtil.addDisposer((Widget)button, (Resource)image);
        return button;
    }

    public void add(DLItem dLItem) {
        this.checkWidget();
        if (dLItem == null) {
            SWT.error((int)4);
        }
        this.items.add(dLItem);
        this.redrawTables();
    }

    public void add(DLItem dLItem, int n) {
        this.checkWidget();
        if (dLItem == null) {
            SWT.error((int)4);
        }
        if (n < 0 || n >= this.items.size()) {
            SWT.error((int)5);
        }
        this.items.add(n, dLItem);
        this.redrawTables();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<SelectionListener>();
        }
        this.selectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        if (this.selectionListeners == null) {
            return;
        }
        this.selectionListeners.remove(selectionListener);
    }

    public void addSelectionChangeListener(SelectionChangeListener selectionChangeListener) {
        this.checkWidget();
        if (selectionChangeListener == null) {
            SWT.error((int)4);
        }
        if (this.selectionChangeListeners == null) {
            this.selectionChangeListeners = new ArrayList<SelectionChangeListener>();
        }
        this.selectionChangeListeners.add(selectionChangeListener);
    }

    public void removeSelectionChangeListener(SelectionChangeListener selectionChangeListener) {
        this.checkWidget();
        if (selectionChangeListener == null) {
            SWT.error((int)4);
        }
        if (this.selectionChangeListeners == null) {
            return;
        }
        this.selectionChangeListeners.remove(selectionChangeListener);
    }

    public void deselect(int n) {
        this.deselect(n, true);
    }

    public void deselectDoNotFireEvent(int n) {
        this.deselect(n, false);
    }

    private void deselect(int n, boolean bl) {
        this.checkWidget();
        if (n < 0 || n >= this.items.size()) {
            return;
        }
        DLItem dLItem = this.selection.remove(n);
        if (bl) {
            this.fireSelectionEvent(dLItem);
        }
        ArrayList<DLItem> arrayList = new ArrayList<DLItem>();
        dLItem.setLastAction(DLItem.LAST_ACTION.DESELECTION);
        arrayList.add(dLItem);
        if (bl) {
            this.fireSelectionChangeEvent(arrayList);
        }
        this.redrawTables();
    }

    public void deselect(int[] nArray) {
        this.deselect(nArray, true);
    }

    public void deselectDoNotFireEvent(int[] nArray) {
        this.deselect(nArray, false);
    }

    private void deselect(int[] nArray, boolean bl) {
        this.checkWidget();
        if (nArray == null) {
            SWT.error((int)4);
        }
        ArrayList<DLItem> arrayList = new ArrayList<DLItem>();
        for (int n : nArray) {
            if (n < 0 || n >= this.items.size()) continue;
            arrayList.add(this.selection.get(n));
        }
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            DLItem dLItem = (DLItem)object.next();
            this.selection.remove(dLItem);
            if (!bl) continue;
            this.fireSelectionEvent(dLItem);
        }
        if (bl) {
            this.fireSelectionChangeEvent(arrayList);
        }
        arrayList.clear();
        this.redrawTables();
    }

    public void deselect(int n, int n2) {
        this.deselect(n, n2, true);
    }

    public void deselectDoNotFireEvent(int n, int n2) {
        this.deselect(n, n2, false);
    }

    private void deselect(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n > n2) {
            SWT.error((int)6);
        }
        ArrayList<DLItem> arrayList = new ArrayList<DLItem>();
        for (int i = n; i <= n2; ++i) {
            if (i < 0 || i >= this.items.size()) continue;
            arrayList.add(this.selection.get(i));
        }
        for (DLItem dLItem : arrayList) {
            this.selection.remove(dLItem);
            if (!bl) continue;
            this.fireSelectionEvent(dLItem);
        }
        if (bl) {
            this.fireSelectionChangeEvent(arrayList);
        }
        arrayList.clear();
        this.redrawTables();
    }

    public void deselectAll() {
        this.deselectAll(true);
    }

    public void deselectAllDoNotFireEvent() {
        this.deselectAll(false);
    }

    public void deselectAll(boolean bl) {
        this.checkWidget();
        this.items.addAll(this.selection);
        ArrayList<DLItem> arrayList = new ArrayList<DLItem>();
        for (DLItem dLItem : this.selection) {
            dLItem.setLastAction(DLItem.LAST_ACTION.DESELECTION);
            arrayList.add(dLItem);
            if (!bl) continue;
            this.fireSelectionEvent(dLItem);
        }
        this.fireSelectionChangeEvent(arrayList);
        this.selection.clear();
        this.redrawTables();
    }

    public DLItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.size()) {
            SWT.error((int)5);
        }
        return this.items.get(n);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.size();
    }

    public DLItem[] getItems() {
        this.checkWidget();
        return this.items.toArray(new DLItem[this.items.size()]);
    }

    public List<DLItem> getItemsAsList() {
        this.checkWidget();
        return new ArrayList<DLItem>(this.items);
    }

    public DLItem[] getSelection() {
        this.checkWidget();
        return this.selection.toArray(new DLItem[this.items.size()]);
    }

    public List<DLItem> getSelectionAsList() {
        this.checkWidget();
        return new ArrayList<DLItem>(this.selection);
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.selection.size();
    }

    public void remove(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.size()) {
            SWT.error((int)5);
        }
        this.items.remove(n);
        this.redrawTables();
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        for (int n : nArray) {
            if (n < 0 || n >= this.items.size()) {
                SWT.error((int)5);
            }
            this.items.remove(n);
        }
        this.redrawTables();
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            SWT.error((int)5);
        }
        for (int i = n; i < n2; ++i) {
            if (i < 0 || i >= this.items.size()) {
                SWT.error((int)5);
            }
            this.items.remove(i);
        }
        this.redrawTables();
    }

    public void remove(DLItem dLItem) {
        this.checkWidget();
        if (dLItem == null) {
            SWT.error((int)4);
        }
        if (!this.items.contains(dLItem)) {
            SWT.error((int)5);
        }
        this.items.remove(dLItem);
        this.redrawTables();
    }

    public void removeAll() {
        this.checkWidget();
        this.items.clear();
        this.redrawTables();
    }

    public void select(int n) {
        this.select(n, true);
    }

    public void selectDoNotFireEvent(int n) {
        this.select(n, false);
    }

    private void select(int n, boolean bl) {
        this.checkWidget();
        if (n < 0 || n >= this.items.size()) {
            return;
        }
        ArrayList<DLItem> arrayList = new ArrayList<DLItem>();
        DLItem dLItem = this.items.get(n);
        dLItem.setLastAction(DLItem.LAST_ACTION.SELECTION);
        arrayList.add(dLItem);
        this.selection.add(dLItem);
        if (bl) {
            this.fireSelectionEvent(dLItem);
            this.fireSelectionChangeEvent(arrayList);
        }
        this.redrawTables();
    }

    public void select(int[] nArray) {
        this.select(nArray, true);
    }

    public void selectDoNotFireEvent(int[] nArray) {
        this.select(nArray, false);
    }

    private void select(int[] nArray, boolean bl) {
        this.checkWidget();
        if (nArray == null) {
            SWT.error((int)4);
        }
        ArrayList<DLItem> arrayList = new ArrayList<DLItem>();
        for (int n : nArray) {
            if (n < 0 || n >= this.items.size()) continue;
            DLItem dLItem = this.items.get(n);
            dLItem.setLastAction(DLItem.LAST_ACTION.SELECTION);
            arrayList.add(dLItem);
            this.selection.add(dLItem);
            if (!bl) continue;
            this.fireSelectionEvent(dLItem);
        }
        if (bl) {
            this.fireSelectionChangeEvent(arrayList);
        }
        this.redrawTables();
    }

    public void select(int n, int n2) {
        this.select(n, n2, true);
    }

    public void selectDoNotFireEvent(int n, int n2) {
        this.select(n, n2, false);
    }

    private void select(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n > n2) {
            SWT.error((int)6);
        }
        ArrayList<DLItem> arrayList = new ArrayList<DLItem>();
        for (int i = n; i <= n2; ++i) {
            if (i < 0 || i >= this.items.size()) continue;
            DLItem dLItem = this.items.get(i);
            dLItem.setLastAction(DLItem.LAST_ACTION.SELECTION);
            arrayList.add(dLItem);
            this.selection.add(dLItem);
            if (!bl) continue;
            this.fireSelectionEvent(dLItem);
        }
        if (bl) {
            this.fireSelectionChangeEvent(arrayList);
        }
        this.redrawTables();
    }

    public void selectAll() {
        this.selectAll(true);
    }

    public void selectAllDoNotFireEvent() {
        this.selectAll(false);
    }

    private void selectAll(boolean bl) {
        this.checkWidget();
        this.selection.addAll(this.items);
        if (bl) {
            for (DLItem object : this.items) {
                this.fireSelectionEvent(object);
            }
        }
        if (bl) {
            ArrayList arrayList = new ArrayList();
            for (DLItem dLItem : this.items) {
                dLItem.setLastAction(DLItem.LAST_ACTION.SELECTION);
                arrayList.add(dLItem);
            }
            this.fireSelectionChangeEvent(arrayList);
        }
        this.items.clear();
        this.redrawTables();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        boolean bl = this.itemsContainImage();
        Point point = this.itemsTable.computeSize(-1, -1);
        Point point2 = this.selectionTable.computeSize(-1, -1);
        int n5 = this.itemsTable.getSize().x;
        if (point.y > this.itemsTable.getSize().y) {
            n5 -= this.itemsTable.getVerticalBar().getSize().x;
        }
        int n6 = this.selectionTable.getSize().x;
        if (point2.y > this.selectionTable.getSize().y) {
            n6 -= this.selectionTable.getVerticalBar().getSize().x;
        }
        if (bl) {
            this.itemsTable.getColumn(0).pack();
            this.itemsTable.getColumn(1).setWidth(n5 - this.itemsTable.getColumn(0).getWidth());
            this.selectionTable.getColumn(0).pack();
            this.selectionTable.getColumn(1).setWidth(n6 - this.selectionTable.getColumn(0).getWidth());
        } else {
            this.itemsTable.getColumn(0).setWidth(n5);
            this.selectionTable.getColumn(0).setWidth(n6);
        }
        this.itemsTable.getColumn(0).pack();
        this.selectionTable.getColumn(0).pack();
    }

    private boolean itemsContainImage() {
        for (DLItem dLItem : this.items) {
            if (dLItem.getImage() == null) continue;
            return true;
        }
        for (DLItem dLItem : this.selection) {
            if (dLItem.getImage() == null) continue;
            return true;
        }
        return false;
    }

    public void setItem(int n, DLItem dLItem) {
        this.checkWidget();
        if (dLItem == null) {
            SWT.error((int)4);
        }
        if (n < 0 || n >= this.items.size()) {
            SWT.error((int)6);
        }
        this.items.set(n, dLItem);
        this.redrawTables();
    }

    public void setItems(DLItem[] dLItemArray) {
        this.checkWidget();
        if (dLItemArray == null) {
            SWT.error((int)4);
        }
        ArrayList<DLItem> arrayList = new ArrayList<DLItem>();
        for (DLItem dLItem : dLItemArray) {
            if (dLItem == null) {
                SWT.error((int)5);
            }
            arrayList.add(dLItem);
        }
        this.items.clear();
        this.items.addAll(arrayList);
        this.redrawTables();
    }

    public void setItems(List<DLItem> list) {
        this.checkWidget();
        this.checkWidget();
        if (list == null) {
            SWT.error((int)4);
        }
        ArrayList<DLItem> arrayList = new ArrayList<DLItem>();
        for (DLItem dLItem : list) {
            if (dLItem == null) {
                SWT.error((int)5);
            }
            arrayList.add(dLItem);
        }
        this.items.clear();
        this.items.addAll(arrayList);
        this.redrawTables();
    }

    private void redrawTables() {
        this.setRedraw(false);
        this.redrawTable(this.itemsTable, false);
        this.redrawTable(this.selectionTable, true);
        this.setRedraw(true);
        this.setBounds(this.getBounds());
    }

    private void redrawTable(Table table, boolean bl) {
        this.clean(table);
        this.fillData(table, bl ? this.selection : this.items);
    }

    private void clean(Table table) {
        if (table == null) {
            return;
        }
        for (TableItem tableItem : table.getItems()) {
            tableItem.dispose();
        }
    }

    private void fillData(Table table, List<DLItem> list) {
        boolean bl = this.itemsContainImage();
        for (DLItem dLItem : list) {
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setData((Object)dLItem);
            if (dLItem.getBackground() != null) {
                tableItem.setBackground(dLItem.getBackground());
            }
            if (dLItem.getForeground() != null) {
                tableItem.setForeground(dLItem.getForeground());
            }
            if (dLItem.getImage() != null) {
                tableItem.setImage(0, dLItem.getImage());
            }
            if (dLItem.getFont() != null) {
                tableItem.setFont(dLItem.getFont());
            }
            int n = bl ? 1 : 0;
            tableItem.setText(n, dLItem.getText());
        }
    }

    protected void moveSelectionToFirstPosition() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        int n = 0;
        for (TableItem tableItem : this.selectionTable.getSelection()) {
            DLItem dLItem = (DLItem)tableItem.getData();
            this.selection.remove(dLItem);
            this.selection.add(n++, dLItem);
        }
        this.redrawTables();
        this.selectionTable.select(0, n - 1);
        this.selectionTable.forceFocus();
    }

    protected void selectItem() {
        if (this.itemsTable.getSelectionCount() == 0) {
            return;
        }
        ArrayList<DLItem> arrayList = new ArrayList<DLItem>();
        for (TableItem tableItem : this.itemsTable.getSelection()) {
            DLItem dLItem = (DLItem)tableItem.getData();
            dLItem.setLastAction(DLItem.LAST_ACTION.SELECTION);
            arrayList.add(dLItem);
            this.selection.add(dLItem);
            this.items.remove(dLItem);
            this.fireSelectionEvent(dLItem);
        }
        this.fireSelectionChangeEvent(arrayList);
        this.redrawTables();
    }

    protected void moveUpItem() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        for (int n : this.selectionTable.getSelectionIndices()) {
            if (n != 0) continue;
            this.selectionTable.forceFocus();
            return;
        }
        int[] nArray = new int[this.selectionTable.getSelectionCount()];
        int n = 0;
        for (TableItem tableItem : this.selectionTable.getSelection()) {
            int n2 = this.selection.indexOf(tableItem.getData());
            this.swap(n2, n2 - 1);
            nArray[n++] = n2 - 1;
        }
        this.redrawTables();
        this.selectionTable.select(nArray);
        this.selectionTable.forceFocus();
    }

    protected void deselectItem() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        ArrayList<DLItem> arrayList = new ArrayList<DLItem>();
        for (TableItem tableItem : this.selectionTable.getSelection()) {
            DLItem dLItem = (DLItem)tableItem.getData();
            dLItem.setLastAction(DLItem.LAST_ACTION.DESELECTION);
            arrayList.add(dLItem);
            this.items.add(dLItem);
            this.selection.remove(dLItem);
            this.fireSelectionEvent(dLItem);
        }
        this.fireSelectionChangeEvent(arrayList);
        this.redrawTables();
    }

    protected void moveDownItem() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        for (int n : this.selectionTable.getSelectionIndices()) {
            if (n != this.selectionTable.getItemCount() - 1) continue;
            this.selectionTable.forceFocus();
            return;
        }
        int[] nArray = new int[this.selectionTable.getSelectionCount()];
        int n = 0;
        for (TableItem tableItem : this.selectionTable.getSelection()) {
            int n2 = this.selection.indexOf(tableItem.getData());
            this.swap(n2, n2 + 1);
            nArray[n++] = n2 + 1;
        }
        this.redrawTables();
        this.selectionTable.select(nArray);
        this.selectionTable.forceFocus();
    }

    private void swap(int n, int n2) {
        DLItem dLItem = this.selection.get(n);
        this.selection.set(n, this.selection.get(n2));
        this.selection.set(n2, dLItem);
    }

    protected void moveSelectionToLastPosition() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        int n = this.selectionTable.getSelectionCount();
        for (TableItem tableItem : this.selectionTable.getSelection()) {
            DLItem dLItem = (DLItem)tableItem.getData();
            this.selection.remove(dLItem);
            this.selection.add(dLItem);
        }
        this.redrawTables();
        int n2 = this.selectionTable.getItemCount();
        this.selectionTable.select(n2 - n, n2 - 1);
        this.selectionTable.forceFocus();
    }

    private void fireSelectionEvent(DLItem dLItem) {
        if (this.selectionListeners == null) {
            return;
        }
        Event event = new Event();
        event.button = 1;
        event.display = this.getDisplay();
        event.item = null;
        event.widget = this;
        event.data = dLItem;
        SelectionEvent selectionEvent = new SelectionEvent(event);
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.widgetSelected(selectionEvent);
        }
    }

    private void fireSelectionChangeEvent(List<DLItem> list) {
        if (this.selectionChangeListeners == null) {
            return;
        }
        Event event = new Event();
        event.button = 1;
        event.display = this.getDisplay();
        event.item = null;
        event.widget = this;
        SelectionChangeEvent selectionChangeEvent = new SelectionChangeEvent(event);
        selectionChangeEvent.setItems(list);
        for (SelectionChangeListener selectionChangeListener : this.selectionChangeListeners) {
            selectionChangeListener.widgetSelected(selectionChangeEvent);
        }
    }
}

