/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.net.URI;
import java.util.List;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.AvailableIUGroup;
import org.eclipse.equinox.internal.p2.ui.dialogs.CopyUtils;
import org.eclipse.equinox.internal.p2.ui.dialogs.ILayoutConstants;
import org.eclipse.equinox.internal.p2.ui.dialogs.IRepositoryManipulationHook;
import org.eclipse.equinox.internal.p2.ui.dialogs.IRepositorySelectionListener;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.IUDetailsGroup;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.RepositoryManipulatorDropTarget;
import org.eclipse.equinox.internal.p2.ui.dialogs.RepositorySelectionGroup;
import org.eclipse.equinox.internal.p2.ui.model.EmptyElementExplanation;
import org.eclipse.equinox.internal.p2.ui.query.IUViewQueryContext;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.StructuredViewerProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailableIUsPage
extends ProvisioningWizardPage
implements ISelectableIUsPage {
    private static final String DIALOG_SETTINGS_SECTION = "AvailableIUsPage";
    private static final String AVAILABLE_VIEW_TYPE = "AvailableViewType";
    private static final String SHOW_LATEST_VERSIONS_ONLY = "ShowLatestVersionsOnly";
    private static final String HIDE_INSTALLED_IUS = "HideInstalledContent";
    private static final String RESOLVE_ALL = "ResolveInstallWithAllSites";
    private static final String NAME_COLUMN_WIDTH = "AvailableNameColumnWidth";
    private static final String VERSION_COLUMN_WIDTH = "AvailableVersionColumnWidth";
    private static final String LIST_WEIGHT = "AvailableListSashWeight";
    private static final String DETAILS_WEIGHT = "AvailableDetailsSashWeight";
    private static final String LINKACTION = "linkAction";
    Object[] initialSelections;
    IUViewQueryContext queryContext;
    AvailableIUGroup availableIUGroup;
    Composite availableIUButtonBar;
    Link installLink;
    Button useCategoriesCheckbox;
    Button hideInstalledCheckbox;
    Button showLatestVersionsCheckbox;
    Button resolveAllCheckbox;
    Button filterOnEnvCheckBox;
    SashForm sashForm;
    IUColumnConfig nameColumn;
    IUColumnConfig versionColumn;
    StructuredViewerProvisioningListener profileListener;
    Display display;
    int batchCount = 0;
    RepositorySelectionGroup repoSelector;
    IUDetailsGroup iuDetailsGroup;
    Label selectionCount;

    public AvailableIUsPage(ProvisioningUI ui, ProvisioningOperationWizard wizard) {
        super("AvailableSoftwarePage", ui, wizard);
        this.makeQueryContext();
        this.setTitle(ProvUIMessages.AvailableIUsPage_Title);
        this.setDescription(ProvUIMessages.AvailableIUsPage_Description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.display = parent.getDisplay();
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        this.setDropTarget((Control)composite);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.createRepoArea(composite);
        this.sashForm = new SashForm(composite, 512);
        FillLayout fill = new FillLayout();
        this.sashForm.setLayout((Layout)fill);
        GridData data = new GridData(1808);
        this.sashForm.setLayoutData((Object)data);
        Composite aboveSash = new Composite((Composite)this.sashForm, 0);
        GridLayout grid = new GridLayout();
        grid.marginWidth = 0;
        grid.marginHeight = 0;
        aboveSash.setLayout((Layout)grid);
        int filterConstant = 2;
        if (!this.getPolicy().getRepositoriesVisible()) {
            filterConstant = 1;
        }
        this.nameColumn = new IUColumnConfig(ProvUIMessages.ProvUI_NameColumnTitle, 1, 75);
        this.versionColumn = new IUColumnConfig(ProvUIMessages.ProvUI_VersionColumnTitle, 2, 40);
        this.getColumnWidthsFromSettings();
        this.availableIUGroup = new AvailableIUGroup(this.getProvisioningUI(), aboveSash, JFaceResources.getDialogFont(), this.queryContext, new IUColumnConfig[]{this.nameColumn, this.versionColumn}, filterConstant);
        this.availableIUGroup.getStructuredViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AvailableIUsPage.this.updateDetails();
                AvailableIUsPage.this.iuDetailsGroup.enablePropertyLink(AvailableIUsPage.this.availableIUGroup.getSelectedIUElements().length == 1);
            }
        });
        this.availableIUGroup.getCheckboxTreeViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AvailableIUsPage.this.updateSelection();
            }
        });
        this.addViewerProvisioningListeners();
        this.availableIUGroup.setUseBoldFontForFilteredItems(this.queryContext.getViewType() != 3);
        this.setDropTarget(this.availableIUGroup.getStructuredViewer().getControl());
        this.activateCopy(this.availableIUGroup.getStructuredViewer().getControl());
        this.createSelectButtons(aboveSash);
        this.iuDetailsGroup = new IUDetailsGroup((Composite)this.sashForm, (ISelectionProvider)this.availableIUGroup.getStructuredViewer(), -1, true);
        this.sashForm.setWeights(this.getSashWeights());
        Composite controlsComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        controlsComposite.setLayout((Layout)layout);
        gd = new GridData(4, 4, true, false);
        controlsComposite.setLayoutData((Object)gd);
        this.createViewControlsArea(controlsComposite);
        this.initializeWidgetState();
        this.setControl((Control)composite);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AvailableIUsPage.this.removeProvisioningListeners();
            }
        });
        Dialog.applyDialogFont((Control)composite);
    }

    private void createSelectButtons(Composite parent) {
        Composite buttonParent = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonParent.setLayout((Layout)gridLayout);
        GridData data = new GridData(4, -1, true, false);
        buttonParent.setLayoutData((Object)data);
        Button selectAll = new Button(buttonParent, 8);
        selectAll.setText(ProvUIMessages.SelectableIUsPage_Select_All);
        this.setButtonLayoutData(selectAll);
        selectAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AvailableIUsPage.this.setAllChecked(true);
            }
        });
        Button deselectAll = new Button(buttonParent, 8);
        deselectAll.setText(ProvUIMessages.SelectableIUsPage_Deselect_All);
        this.setButtonLayoutData(deselectAll);
        deselectAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AvailableIUsPage.this.setAllChecked(false);
            }
        });
        this.selectionCount = new Label(buttonParent, 0);
        data = new GridData(4, 0x1000000, true, true);
        data.horizontalIndent = 20;
        this.selectionCount.setLayoutData((Object)data);
        Label sep = new Label(buttonParent, 258);
        data = new GridData(4, -1, true, false);
        data.horizontalSpan = 3;
        sep.setLayoutData((Object)data);
    }

    void setAllChecked(boolean checked) {
        if (checked) {
            this.availableIUGroup.getCheckboxTreeViewer().setAllChecked(checked);
            this.availableIUGroup.setChecked(this.availableIUGroup.getCheckboxTreeViewer().getCheckedElements());
        } else {
            this.availableIUGroup.setChecked(new Object[0]);
        }
        this.updateSelection();
    }

    private void createViewControlsArea(Composite parent) {
        this.showLatestVersionsCheckbox = new Button(parent, 32);
        this.showLatestVersionsCheckbox.setText(ProvUIMessages.AvailableIUsPage_ShowLatestVersions);
        this.showLatestVersionsCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AvailableIUsPage.this.updateQueryContext();
                AvailableIUsPage.this.availableIUGroup.updateAvailableViewState();
            }

            public void widgetSelected(SelectionEvent e) {
                AvailableIUsPage.this.updateQueryContext();
                AvailableIUsPage.this.availableIUGroup.updateAvailableViewState();
            }
        });
        this.hideInstalledCheckbox = new Button(parent, 32);
        this.hideInstalledCheckbox.setText(ProvUIMessages.AvailableIUsPage_HideInstalledItems);
        this.hideInstalledCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AvailableIUsPage.this.updateQueryContext();
                AvailableIUsPage.this.availableIUGroup.updateAvailableViewState();
            }

            public void widgetSelected(SelectionEvent e) {
                AvailableIUsPage.this.updateQueryContext();
                AvailableIUsPage.this.availableIUGroup.updateAvailableViewState();
            }
        });
        this.useCategoriesCheckbox = new Button(parent, 32);
        this.useCategoriesCheckbox.setText(ProvUIMessages.AvailableIUsPage_GroupByCategory);
        this.useCategoriesCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AvailableIUsPage.this.updateQueryContext();
                AvailableIUsPage.this.availableIUGroup.updateAvailableViewState();
            }

            public void widgetSelected(SelectionEvent e) {
                AvailableIUsPage.this.updateQueryContext();
                AvailableIUsPage.this.availableIUGroup.updateAvailableViewState();
            }
        });
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        this.installLink = this.createLink(parent, (IAction)new Action(){

            public void runWithEvent(Event event) {
                ProvUI.openInstallationDialog(event);
            }
        }, ProvUIMessages.AvailableIUsPage_GotoInstallInfo);
        this.installLink.setLayoutData((Object)gd);
        this.filterOnEnvCheckBox = new Button(parent, 32);
        this.filterOnEnvCheckBox.setText(ProvUIMessages.AvailableIUsPage_FilterOnEnvCheckBox);
        this.filterOnEnvCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AvailableIUsPage.this.updateQueryContext();
                AvailableIUsPage.this.availableIUGroup.updateAvailableViewState();
            }

            public void widgetSelected(SelectionEvent e) {
                AvailableIUsPage.this.updateQueryContext();
                AvailableIUsPage.this.availableIUGroup.updateAvailableViewState();
            }
        });
        if (this.getPolicy().getRepositoriesVisible()) {
            this.resolveAllCheckbox = new Button(parent, 32);
            this.resolveAllCheckbox.setText(ProvUIMessages.AvailableIUsPage_ResolveAllCheckbox);
            gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = 2;
            this.resolveAllCheckbox.setLayoutData((Object)gd);
        }
    }

    private void createRepoArea(Composite parent) {
        if (this.getPolicy().getRepositoriesVisible()) {
            this.repoSelector = new RepositorySelectionGroup(this.getProvisioningUI(), this.getContainer(), parent, this.queryContext);
            this.repoSelector.addRepositorySelectionListener(new IRepositorySelectionListener(){

                public void repositorySelectionChanged(int repoChoice, URI repoLocation) {
                    AvailableIUsPage.this.repoComboSelectionChanged(repoChoice, repoLocation);
                }
            });
            this.repoSelector.setRepositoryManipulationHook(new IRepositoryManipulationHook(){

                public void preManipulateRepositories() {
                    AvailableIUsPage.this.getProvisioningUI().signalRepositoryOperationComplete(null, false);
                }

                public void postManipulateRepositories() {
                    AvailableIUsPage.this.getProvisioningUI().signalRepositoryOperationStart();
                }
            });
        }
    }

    void repoComboSelectionChanged(int repoChoice, URI repoLocation) {
        if (repoChoice == 2) {
            this.setDescription(ProvUIMessages.AvailableIUsPage_SelectASite);
        } else {
            this.setDescription(ProvUIMessages.AvailableIUsPage_Description);
        }
        this.availableIUGroup.setRepositoryFilter(repoChoice, repoLocation);
        this.updateSelection();
    }

    void updateSelection() {
        int count = this.availableIUGroup.getCheckedLeafIUs().length;
        this.setPageComplete(count > 0);
        if (count == 0) {
            this.selectionCount.setText("");
        } else {
            String message = count == 1 ? ProvUIMessages.AvailableIUsPage_SingleSelectionCount : ProvUIMessages.AvailableIUsPage_MultipleSelectionCount;
            this.selectionCount.setText(NLS.bind((String)message, (Object)Integer.toString(count)));
        }
        this.getProvisioningWizard().operationSelectionsChanged(this);
    }

    void updateQueryContext() {
        this.queryContext.setShowLatestVersionsOnly(this.showLatestVersionsCheckbox.getSelection());
        if (this.hideInstalledCheckbox.getSelection()) {
            this.queryContext.hideAlreadyInstalled(this.getProfileId());
        } else {
            this.queryContext.showAlreadyInstalled();
            this.queryContext.setInstalledProfileId(this.getProfileId());
        }
        if (this.useCategoriesCheckbox.getSelection()) {
            this.queryContext.setViewType(1);
        } else {
            this.queryContext.setViewType(3);
        }
        this.queryContext.setFilterOnEnv(this.filterOnEnvCheckBox.getSelection());
    }

    private Link createLink(Composite parent, IAction action, String text) {
        Link link = new Link(parent, 8);
        link.setText(text);
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IAction linkAction = AvailableIUsPage.this.getLinkAction(event.widget);
                if (linkAction != null) {
                    linkAction.runWithEvent(event);
                }
            }
        });
        link.setToolTipText(action.getToolTipText());
        link.setData(LINKACTION, (Object)action);
        return link;
    }

    IAction getLinkAction(Widget widget) {
        Object data = widget.getData(LINKACTION);
        if (data == null || !(data instanceof IAction)) {
            return null;
        }
        return (IAction)data;
    }

    private void setDropTarget(Control control) {
        if (this.getPolicy().getRepositoriesVisible()) {
            DropTarget target = new DropTarget(control, 7);
            target.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance()});
            target.addDropListener((DropTargetListener)new RepositoryManipulatorDropTarget(this.getProvisioningUI(), control));
        }
    }

    private void initializeWidgetState() {
        this.hideInstalledCheckbox.setSelection(this.queryContext.getHideAlreadyInstalled());
        this.showLatestVersionsCheckbox.setSelection(this.queryContext.getShowLatestVersionsOnly());
        this.useCategoriesCheckbox.setSelection(this.queryContext.shouldGroupByCategories());
        this.filterOnEnvCheckBox.setSelection(this.queryContext.getFilterOnEnv());
        this.availableIUGroup.updateAvailableViewState();
        if (this.initialSelections != null) {
            this.availableIUGroup.setChecked(this.initialSelections);
        }
        Control focusControl = null;
        focusControl = this.repoSelector != null ? this.repoSelector.getDefaultFocusControl() : this.availableIUGroup.getDefaultFocusControl();
        if (focusControl != null) {
            focusControl.setFocus();
        }
        this.updateDetails();
        this.iuDetailsGroup.enablePropertyLink(this.availableIUGroup.getSelectedIUElements().length == 1);
        this.updateSelection();
        if (this.repoSelector != null) {
            this.repoSelector.setRepositorySelection(2, null);
            this.setDescription(ProvUIMessages.AvailableIUsPage_SelectASite);
        }
        if (this.resolveAllCheckbox != null) {
            IDialogSettings settings = ProvUIActivator.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
            String value = null;
            if (section != null) {
                value = section.get(RESOLVE_ALL);
            }
            if (value == null) {
                this.resolveAllCheckbox.setSelection(true);
            } else {
                this.resolveAllCheckbox.setSelection(section.getBoolean(RESOLVE_ALL));
            }
        }
    }

    private void makeQueryContext() {
        IUViewQueryContext defaultQueryContext = ProvUI.getQueryContext(this.getPolicy());
        this.queryContext = new IUViewQueryContext(defaultQueryContext.getViewType());
        if (defaultQueryContext.getHideAlreadyInstalled()) {
            this.queryContext.hideAlreadyInstalled(this.getProfileId());
        } else {
            this.queryContext.setInstalledProfileId(this.getProfileId());
        }
        this.queryContext.setShowLatestVersionsOnly(defaultQueryContext.getShowLatestVersionsOnly());
        IDialogSettings settings = ProvUIActivator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section != null) {
            boolean hideContent;
            try {
                if (section.get(AVAILABLE_VIEW_TYPE) != null) {
                    this.queryContext.setViewType(section.getInt(AVAILABLE_VIEW_TYPE));
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.queryContext.getViewType() == 2) {
                this.queryContext.setViewType(1);
            }
            if (section.get(SHOW_LATEST_VERSIONS_ONLY) != null) {
                this.queryContext.setShowLatestVersionsOnly(section.getBoolean(SHOW_LATEST_VERSIONS_ONLY));
            }
            if (hideContent = section.getBoolean(HIDE_INSTALLED_IUS)) {
                this.queryContext.hideAlreadyInstalled(this.getProfileId());
            } else {
                this.queryContext.setInstalledProfileId(this.getProfileId());
                this.queryContext.showAlreadyInstalled();
            }
        }
    }

    private void getColumnWidthsFromSettings() {
        IDialogSettings settings = ProvUIActivator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section != null) {
            try {
                if (section.get(NAME_COLUMN_WIDTH) != null) {
                    this.nameColumn.setWidthInPixels(section.getInt(NAME_COLUMN_WIDTH));
                }
                if (section.get(VERSION_COLUMN_WIDTH) != null) {
                    this.versionColumn.setWidthInPixels(section.getInt(VERSION_COLUMN_WIDTH));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private int[] getSashWeights() {
        IDialogSettings settings = ProvUIActivator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section != null) {
            try {
                int[] weights = new int[2];
                if (section.get(LIST_WEIGHT) != null) {
                    weights[0] = section.getInt(LIST_WEIGHT);
                    if (section.get(DETAILS_WEIGHT) != null) {
                        weights[1] = section.getInt(DETAILS_WEIGHT);
                        return weights;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return ILayoutConstants.IUS_TO_DETAILS_WEIGHTS;
    }

    @Override
    public void saveBoundsRelatedSettings() {
        if (this.getShell().isDisposed()) {
            return;
        }
        IDialogSettings settings = ProvUIActivator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        section.put(AVAILABLE_VIEW_TYPE, this.queryContext.getViewType());
        section.put(SHOW_LATEST_VERSIONS_ONLY, this.showLatestVersionsCheckbox.getSelection());
        section.put(HIDE_INSTALLED_IUS, this.hideInstalledCheckbox.getSelection());
        if (this.resolveAllCheckbox != null) {
            section.put(RESOLVE_ALL, this.resolveAllCheckbox.getSelection());
        }
        TreeColumn col = this.availableIUGroup.getCheckboxTreeViewer().getTree().getColumn(0);
        section.put(NAME_COLUMN_WIDTH, col.getWidth());
        col = this.availableIUGroup.getCheckboxTreeViewer().getTree().getColumn(1);
        section.put(VERSION_COLUMN_WIDTH, col.getWidth());
        int[] weights = this.sashForm.getWeights();
        section.put(LIST_WEIGHT, weights[0]);
        section.put(DETAILS_WEIGHT, weights[1]);
    }

    void updateDetails() {
        String description;
        Object[] elements = ((IStructuredSelection)this.availableIUGroup.getStructuredViewer().getSelection()).toArray();
        if (elements.length == 1 && elements[0] instanceof EmptyElementExplanation && (description = ((EmptyElementExplanation)elements[0]).getDescription()) != null) {
            this.iuDetailsGroup.setDetailText(description);
            return;
        }
        List<IInstallableUnit> selected = this.getSelectedIUs();
        if (selected.size() == 1) {
            StringBuffer result = new StringBuffer();
            String description2 = selected.get(0).getProperty("org.eclipse.equinox.p2.description", null);
            if (description2 != null) {
                result.append(description2);
            } else {
                String name = selected.get(0).getProperty("org.eclipse.equinox.p2.name", null);
                if (name != null) {
                    result.append(name);
                } else {
                    result.append(selected.get(0).getId());
                }
                result.append(" ");
                result.append(selected.get(0).getVersion().toString());
            }
            this.iuDetailsGroup.setDetailText(result.toString());
            return;
        }
        this.iuDetailsGroup.setDetailText("");
    }

    public List<IInstallableUnit> getSelectedIUs() {
        return this.availableIUGroup.getSelectedIUs();
    }

    public AvailableIUGroup testGetAvailableIUGroup() {
        return this.availableIUGroup;
    }

    public IInstallableUnit[] getCheckedIUs() {
        return this.availableIUGroup.getCheckedLeafIUs();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    @Override
    public Object[] getCheckedIUElements() {
        return this.availableIUGroup.getCheckedLeafIUs();
    }

    @Override
    public Object[] getSelectedIUElements() {
        return this.availableIUGroup.getSelectedIUElements();
    }

    @Override
    public void setCheckedElements(Object[] elements) {
        if (this.availableIUGroup == null) {
            this.initialSelections = elements;
        } else {
            this.availableIUGroup.setChecked(elements);
        }
    }

    void addViewerProvisioningListeners() {
        this.profileListener = new StructuredViewerProvisioningListener(this.getClass().getName(), this.availableIUGroup.getStructuredViewer(), 4, this.getProvisioningUI().getOperationRunner()){

            protected void profileAdded(String id) {
            }

            protected void profileRemoved(String id) {
            }

            protected void profileChanged(String id) {
                if (id.equals(AvailableIUsPage.this.getProfileId())) {
                    this.safeRefresh();
                }
            }
        };
        ProvUI.getProvisioningEventBus(this.getProvisioningUI().getSession()).addListener((ProvisioningListener)this.profileListener);
    }

    void removeProvisioningListeners() {
        if (this.profileListener != null) {
            ProvUI.getProvisioningEventBus(this.getProvisioningUI().getSession()).removeListener((ProvisioningListener)this.profileListener);
            this.profileListener = null;
        }
    }

    @Override
    protected String getClipboardText(Control control) {
        return CopyUtils.getIndentedClipboardText(this.getSelectedIUElements(), new IUDetailsLabelProvider());
    }

    public ProvisioningContext getProvisioningContext() {
        if (!this.getPolicy().getRepositoriesVisible() || this.repoSelector == null) {
            return new ProvisioningContext(this.getProvisioningUI().getSession().getProvisioningAgent());
        }
        if (this.resolveAllCheckbox.getSelection()) {
            return new ProvisioningContext(this.getProvisioningUI().getSession().getProvisioningAgent());
        }
        return this.repoSelector.getProvisioningContext();
    }
}

