/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.httpclient;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemRequest;
import org.eclipse.ecf.filetransfer.RemoteFileSystemException;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.service.IRemoteFileSystemBrowser;
import org.eclipse.ecf.filetransfer.service.IRemoteFileSystemBrowserFactory;
import org.eclipse.ecf.provider.filetransfer.httpclient.HttpClientFileSystemBrowser;
import org.eclipse.ecf.provider.filetransfer.identity.FileTransferNamespace;
import org.eclipse.osgi.util.NLS;

public class HttpClientBrowseFileTransferFactory
implements IRemoteFileSystemBrowserFactory {
    public IRemoteFileSystemBrowser newInstance() {
        return new IRemoteFileSystemBrowser(){
            private Proxy proxy;
            private IConnectContext connectContext;

            public Namespace getBrowseNamespace() {
                return IDFactory.getDefault().getNamespaceByName(FileTransferNamespace.PROTOCOL);
            }

            public IRemoteFileSystemRequest sendBrowseRequest(IFileID directoryOrFileId, IRemoteFileSystemListener listener) throws RemoteFileSystemException {
                URL url;
                Assert.isNotNull((Object)directoryOrFileId);
                Assert.isNotNull((Object)listener);
                try {
                    url = directoryOrFileId.getURL();
                }
                catch (MalformedURLException e) {
                    throw new RemoteFileSystemException(NLS.bind((String)"Exception creating URL for {0}", (Object)directoryOrFileId));
                }
                HttpClientFileSystemBrowser browser = new HttpClientFileSystemBrowser(new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager()), directoryOrFileId, listener, url, this.connectContext, this.proxy);
                return browser.sendBrowseRequest();
            }

            public void setConnectContextForAuthentication(IConnectContext connectContext) {
                this.connectContext = connectContext;
            }

            public void setProxy(Proxy proxy) {
                this.proxy = proxy;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }
        };
    }
}

