/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain.payment;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.Length;
import ru.ssa.cashadmin.domain.payment.Provider;

@Entity
@Table(name="accountmask")
@MappedSuperclass
public class Accountmask
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue
    private Integer maskid;
    @ManyToOne
    @JoinColumn(name="providerid", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    private Provider provider;
    @NotNull
    private Integer providerid;
    @NotNull
    @Length(max=200, min=1)
    private String mask;
    @Length(max=200)
    private String transform;

    protected Accountmask() {
    }

    public Integer getMaskid() {
        return this.maskid;
    }

    public void setMaskid(Integer maskid) {
        this.maskid = maskid;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
        this.providerid = provider.getProviderid();
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public String getTransform() {
        return this.transform;
    }

    public void setTransform(String transform) {
        this.transform = transform;
    }

    public Integer getProviderid() {
        return this.providerid;
    }

    public void setProviderid(Integer providerid) {
        this.providerid = providerid;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.maskid == null ? 0 : this.maskid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Accountmask other = (Accountmask)obj;
        return !(this.maskid == null ? other.maskid != null : !this.maskid.equals(other.maskid));
    }

    public String toString() {
        return "Accountmask [maskid=" + this.maskid + ", providerid=" + this.providerid + ", mask=" + this.mask + "]";
    }
}

