/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.views;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.contexts.IContextService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.cashserver.security.SecurityKey;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.holders.CommandHolder;
import su.artix.discountmanager.holders.MenuHolder;
import su.artix.discountmanager.holders.PopupMenuHolderDiscountSystem;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.discountmanager.providers.bonussystem.LimitBonusSystemLabelProvider;
import su.artix.discountmanager.providers.discountsystem.DiscountSystemContentProvider;
import su.artix.discountmanager.trees.CustomSystemTreeViewer;
import su.artix.discountmanager.views.BonusView;
import su.artix.discountmanager.views.IViewPartCustomize;
import su.artix.discountmanager.views.TreeUtils;
import su.artix.discountmanagercore.dao.discountsystem.DiscountSystemDAO;
import su.artix.discountmanagercore.dao.discountsystem.LimitBonusSystemDAO;
import su.artix.yuki.view.MementoPersistStore;

@SecurityKey(title="\u041f\u0440\u0430\u0432\u0438\u043b\u0430 \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0431\u043e\u043d\u0443\u0441\u043e\u0432")
public class LimitBonusSystemView
extends BonusView
implements ISelectionListener,
IViewPartCustomize,
MementoPersistStore {
    private static final Logger log = LoggerFactory.getLogger(LimitBonusSystemView.class);
    public static final String ID = "su.artix.discountmanager.views.limitview";
    private CustomSystemTreeViewer systemTreeViewer;
    private final DiscountSystemDAO systemDAO = (DiscountSystemDAO)Activator.getDefault().getBeanByClass(LimitBonusSystemDAO.class);
    private IMemento memento;

    public IMemento getMemento() {
        return this.memento;
    }

    public void saveState(IMemento memento) {
        memento.putMemento(this.memento);
        super.saveState(memento);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento == null ? XMLMemento.createWriteRoot((String)"temped_null_memento") : memento;
    }

    @Override
    public void createPartControl(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.systemTreeViewer = new CustomSystemTreeViewer(parent, (IWorkbenchPart)this, ID);
        this.systemTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CommandHolder.INSTANCE.executeCommand("su.artix.discountmanager.commands.edit", null);
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.systemTreeViewer.getTree());
        this.systemTreeViewer.setContentProvider((IContentProvider)new DiscountSystemContentProvider(DiscountSystemDAO.SystemType.LIMIT_BONUS_SYSTEM));
        this.systemTreeViewer.setLabelProvider((IBaseLabelProvider)new LimitBonusSystemLabelProvider());
        this.systemTreeViewer.setInput(this.systemDAO);
        TreeUtils.expandTreeToGroups(this.systemTreeViewer);
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.systemTreeViewer.getTree());
        this.systemTreeViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.systemTreeViewer);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.systemTreeViewer);
        this.activateHandlers();
    }

    private void activateHandlers() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("yuki.discount.context");
        }
    }

    @Override
    public void setFocus() {
        this.systemTreeViewer.getControl().setFocus();
        ViewHolder.INSTANCE.setActiveSystemViewPart((IWorkbenchPart)this);
        Object[] expandElements = this.systemTreeViewer.getExpandedElements();
        this.systemTreeViewer.refresh();
        this.systemTreeViewer.setExpandedElements(expandElements);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection selectionIn = (IStructuredSelection)selection;
            if (part instanceof LimitBonusSystemView) {
                ViewHolder.INSTANCE.setActiveViewPart((IWorkbenchPart)this);
                this.initializePopupMenu(selectionIn.getFirstElement());
            }
        }
    }

    public void initializePopupMenu(Object currentObject) {
        MenuHolder.INSTANCE.setActiveExport(true);
        PopupMenuHolderDiscountSystem.INSTANCE.initialize(currentObject);
    }

    @Override
    public void setImage(Image image) {
        this.setTitleImage(image);
    }

    @Override
    public void setTitleName(String title) {
        this.setPartName(title);
    }

    @Override
    public void setIsChangedView(Boolean isChanged) {
        String title = StringUtils.remove((String)this.getTitle(), (char)'*');
        if (isChanged.booleanValue()) {
            this.setTitleName("*" + title);
            this.systemTreeViewer.setIsChanged(true);
        } else {
            this.setPartName(title);
            this.systemTreeViewer.setIsChanged(false);
        }
    }
}

