/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart.undoredo.commands;

import java.util.Calendar;
import org.eclipse.nebula.widgets.ganttchart.GanttEvent;
import org.eclipse.nebula.widgets.ganttchart.GanttSection;
import org.eclipse.nebula.widgets.ganttchart.undoredo.commands.AbstractUndoRedoCommand;

public class EventMoveCommand
extends AbstractUndoRedoCommand {
    private GanttEvent _event;
    private Calendar _startDateBefore;
    private Calendar _startDateAfter;
    private Calendar _endDateBefore;
    private Calendar _endDateAfter;
    private Calendar _revisedStartDateBefore;
    private Calendar _revisedStartDateAfter;
    private Calendar _revisedEndDateBefore;
    private Calendar _revisedEndDateAfter;
    private int _indexBefore;
    private int _indexAfter;
    private int _sectionBefore;
    private int _sectionAfter;

    public EventMoveCommand(GanttEvent event, Calendar startDateBefore, Calendar startDateAfter, Calendar endDateBefore, Calendar endDateAfter, Calendar revisedStartDateBefore, Calendar revisedStartDateAfter, Calendar revisedEndDateBefore, Calendar revisedEndDateAfter, GanttSection sectionBefore, GanttSection sectionAfter, int indexBefore, int indexAfter) {
        this._event = event;
        this._startDateBefore = (Calendar)startDateBefore.clone();
        this._startDateAfter = (Calendar)startDateAfter.clone();
        if (revisedStartDateBefore != null) {
            this._revisedStartDateBefore = (Calendar)revisedStartDateBefore.clone();
        }
        if (revisedStartDateAfter != null) {
            this._revisedStartDateAfter = (Calendar)revisedStartDateAfter.clone();
        }
        this._endDateBefore = (Calendar)endDateBefore.clone();
        this._endDateAfter = (Calendar)endDateAfter.clone();
        if (revisedEndDateBefore != null) {
            this._revisedEndDateBefore = (Calendar)revisedEndDateBefore.clone();
        }
        if (revisedEndDateAfter != null) {
            this._revisedEndDateAfter = (Calendar)revisedEndDateAfter.clone();
        }
        this._indexBefore = indexBefore;
        this._indexAfter = indexAfter;
        this._sectionBefore = sectionBefore == null ? -1 : this._event.getParentComposite().getGanttSections().indexOf(sectionBefore);
        this._sectionAfter = sectionAfter == null ? -1 : this._event.getParentComposite().getGanttSections().indexOf(sectionAfter);
    }

    public void dispose() {
    }

    public void redo() {
        this._event.setNoUpdatePlannedDates(this._startDateAfter, this._endDateAfter);
        this._event.setNoUpdateRevisedDates(this._revisedStartDateAfter, this._revisedEndDateAfter);
        if (this._sectionAfter != -1 && this._indexAfter > -1) {
            this._event.reparentToNewGanttSection(this._indexAfter, (GanttSection)this._event.getParentComposite().getGanttSections().get(this._sectionAfter));
        }
        if (this._event.getGanttSection() == null && this._indexAfter != -1) {
            this._event.getParentChart().reindex(this._event, this._indexAfter);
        }
    }

    public void undo() {
        this._event.setNoUpdatePlannedDates(this._startDateBefore, this._endDateBefore);
        this._event.setNoUpdateRevisedDates(this._revisedStartDateBefore, this._revisedEndDateBefore);
        if (this._sectionBefore != -1 && this._indexBefore > -1) {
            this._event.reparentToNewGanttSection(this._indexBefore, (GanttSection)this._event.getParentComposite().getGanttSections().get(this._sectionBefore));
        }
        if (this._event.getGanttSection() == null && this._indexBefore != -1) {
            this._event.getParentChart().reindex(this._event, this._indexBefore);
        }
    }

    public GanttEvent getEvent() {
        return this._event;
    }

    public void setEvent(GanttEvent event) {
        this._event = event;
    }

    public Calendar getStartDateBefore() {
        return this._startDateBefore;
    }

    public void setStartDateBefore(Calendar startDateBefore) {
        this._startDateBefore = startDateBefore;
    }

    public Calendar getStartDateAfter() {
        return this._startDateAfter;
    }

    public void setStartDateAfter(Calendar startDateAfter) {
        this._startDateAfter = startDateAfter;
    }

    public Calendar getEndDateBefore() {
        return this._endDateBefore;
    }

    public void setEndDateBefore(Calendar endDateBefore) {
        this._endDateBefore = endDateBefore;
    }

    public Calendar getEndDateAfter() {
        return this._endDateAfter;
    }

    public void setEndDateAfter(Calendar endDateAfter) {
        this._endDateAfter = endDateAfter;
    }

    public int getIndexBefore() {
        return this._indexBefore;
    }

    public void setIndexBefore(int indexBefore) {
        this._indexBefore = indexBefore;
    }

    public int getIndexAfter() {
        return this._indexAfter;
    }

    public void setIndexAfter(int indexAfter) {
        this._indexAfter = indexAfter;
    }

    public int getSectionBefore() {
        return this._sectionBefore;
    }

    public void setSectionBefore(int sectionBefore) {
        this._sectionBefore = sectionBefore;
    }

    public int getSectionAfter() {
        return this._sectionAfter;
    }

    public void setSectionAfter(int sectionAfter) {
        this._sectionAfter = sectionAfter;
    }

    public Calendar getRevisedStartDateBefore() {
        return this._revisedStartDateBefore;
    }

    public void setRevisedStartDateBefore(Calendar revisedStartDateBefore) {
        this._revisedStartDateBefore = revisedStartDateBefore;
    }

    public Calendar getRevisedStartDateAfter() {
        return this._revisedStartDateAfter;
    }

    public void setRevisedStartDateAfter(Calendar revisedStartDateAfter) {
        this._revisedStartDateAfter = revisedStartDateAfter;
    }

    public Calendar getRevisedEndDateBefore() {
        return this._revisedEndDateBefore;
    }

    public void setRevisedEndDateBefore(Calendar revisedEndDateBefore) {
        this._revisedEndDateBefore = revisedEndDateBefore;
    }

    public Calendar getRevisedEndDateAfter() {
        return this._revisedEndDateAfter;
    }

    public void setRevisedEndDateAfter(Calendar revisedEndDateAfter) {
        this._revisedEndDateAfter = revisedEndDateAfter;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(200);
        buf.append("[EventMove: ");
        buf.append(this._event);
        buf.append(" was moved from section ");
        buf.append(this._sectionBefore);
        buf.append(" to ");
        buf.append(this._sectionAfter);
        buf.append('\n');
        buf.append("\tEsti Start: ");
        buf.append(this.quickFormat(this._startDateBefore));
        buf.append(" -> ");
        buf.append(this.quickFormat(this._startDateAfter));
        buf.append('\n');
        buf.append("\tEsti End: ");
        buf.append(this.quickFormat(this._endDateBefore));
        buf.append(" -> ");
        buf.append(this.quickFormat(this._endDateAfter));
        buf.append('\n');
        buf.append("\tRe Start: ");
        buf.append(this.quickFormat(this._revisedStartDateBefore));
        buf.append(" -> ");
        buf.append(this.quickFormat(this._revisedStartDateAfter));
        buf.append('\n');
        buf.append("\tRe End: ");
        buf.append(this.quickFormat(this._revisedEndDateBefore));
        buf.append(" -> ");
        buf.append(this.quickFormat(this._revisedEndDateAfter));
        buf.append('\n');
        buf.append(']');
        return buf.toString();
    }

    private String quickFormat(Calendar cal) {
        if (cal == null) {
            return "<null>";
        }
        return cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5);
    }
}

