/*
 * Decompiled with CFR 0.152.
 */
package su.artix.accounting.domain;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import su.artix.accounting.domain.Asset;
import su.artix.accounting.domain.Terminal;
import su.artix.accounting.domain.TransactionStatus;

@Entity
@Table(name="assetTransactionStatus")
@Document
public class AssetTransactionStatus
implements Serializable {
    private static final long serialVersionUID = 938521082339870883L;
    long id;
    @DBRef(db="terminal")
    private Terminal terminal;
    private TransactionStatus transactionStatus;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date date = new Date();
    private String transactionReason;
    private String transactionSource;
    private Asset asset;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @JoinColumn(name="terminalNumber", referencedColumnName="terminalId")
    @ManyToOne
    public Terminal getTerminal() {
        return this.terminal;
    }

    public void setTerminal(Terminal terminal) {
        this.terminal = terminal;
    }

    @Enumerated(value=EnumType.STRING)
    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getTransactionReason() {
        return this.transactionReason;
    }

    public void setTransactionReason(String transactionReason) {
        this.transactionReason = transactionReason;
    }

    @ManyToOne
    @JoinColumn(name="asset_id", insertable=false, updatable=false)
    public Asset getAsset() {
        return this.asset;
    }

    private void setAsset(Asset asset) {
        this.asset = asset;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AssetTransactionStatus [terminal=");
        builder.append(this.terminal);
        builder.append(", transactionStatus=");
        builder.append((Object)this.transactionStatus);
        builder.append(", date=");
        builder.append(this.date);
        builder.append(", transactionReason=");
        builder.append(this.transactionReason);
        builder.append("]");
        return builder.toString();
    }

    public String getTransactionSource() {
        return this.transactionSource;
    }

    public void setTransactionSource(String transactionSource) {
        this.transactionSource = transactionSource;
    }
}

