/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class HTMLStyledTextParser {
    private final StyledText styledText;
    private StringBuilder output;
    private StringBuilder currentTag;
    private final List<StyleRange> listOfStyles;
    private final LinkedList<StyleRange> stack;
    private int currentPosition;
    private final int defaultHeight;
    private static final Map<String, Integer[]> HTML_CODES = HTMLStyledTextParser.initHTMLCode();

    HTMLStyledTextParser(StyledText styledText) {
        this.styledText = styledText;
        this.listOfStyles = new ArrayList<StyleRange>();
        this.stack = new LinkedList();
        FontData fontData = styledText.getFont().getFontData()[0];
        this.defaultHeight = fontData.getHeight();
    }

    private static Map<String, Integer[]> initHTMLCode() {
        HashMap<String, Integer[]> hashMap = new HashMap<String, Integer[]>();
        hashMap.put("aliceblue", new Integer[]{240, 248, 255});
        hashMap.put("antiquewhite", new Integer[]{250, 235, 215});
        hashMap.put("aqua", new Integer[]{0, 255, 255});
        hashMap.put("aquamarine", new Integer[]{127, 255, 212});
        hashMap.put("azure", new Integer[]{240, 255, 255});
        hashMap.put("beige", new Integer[]{245, 245, 220});
        hashMap.put("bisque", new Integer[]{255, 228, 196});
        hashMap.put("black", new Integer[]{0, 0, 0});
        hashMap.put("blanchedalmond", new Integer[]{255, 235, 205});
        hashMap.put("blue", new Integer[]{0, 0, 255});
        hashMap.put("blueviolet", new Integer[]{138, 43, 226});
        hashMap.put("brown", new Integer[]{165, 42, 42});
        hashMap.put("burlywood", new Integer[]{222, 184, 135});
        hashMap.put("cadetblue", new Integer[]{95, 158, 160});
        hashMap.put("chartreuse", new Integer[]{127, 255, 0});
        hashMap.put("chocolate", new Integer[]{210, 105, 30});
        hashMap.put("coral", new Integer[]{255, 127, 80});
        hashMap.put("cornflowerblue", new Integer[]{100, 149, 237});
        hashMap.put("cornsilk", new Integer[]{255, 248, 220});
        hashMap.put("crimson", new Integer[]{220, 20, 60});
        hashMap.put("cyan", new Integer[]{0, 255, 255});
        hashMap.put("darkblue", new Integer[]{0, 0, 139});
        hashMap.put("darkcyan", new Integer[]{0, 139, 139});
        hashMap.put("darkgoldenrod", new Integer[]{184, 134, 11});
        hashMap.put("darkgray", new Integer[]{169, 169, 169});
        hashMap.put("darkgreen", new Integer[]{0, 100, 0});
        hashMap.put("darkgrey", new Integer[]{169, 169, 169});
        hashMap.put("darkkhaki", new Integer[]{189, 183, 107});
        hashMap.put("darkmagenta", new Integer[]{139, 0, 139});
        hashMap.put("darkolivegreen", new Integer[]{85, 107, 47});
        hashMap.put("darkorange", new Integer[]{255, 140, 0});
        hashMap.put("darkorchid", new Integer[]{153, 50, 204});
        hashMap.put("darkred", new Integer[]{139, 0, 0});
        hashMap.put("darksalmon", new Integer[]{233, 150, 122});
        hashMap.put("darkseagreen", new Integer[]{143, 188, 143});
        hashMap.put("darkslateblue", new Integer[]{72, 61, 139});
        hashMap.put("darkslategray", new Integer[]{47, 79, 79});
        hashMap.put("darkslategrey", new Integer[]{47, 79, 79});
        hashMap.put("darkturquoise", new Integer[]{0, 206, 209});
        hashMap.put("darkviolet", new Integer[]{148, 0, 211});
        hashMap.put("deeppink", new Integer[]{255, 20, 147});
        hashMap.put("deepskyblue", new Integer[]{0, 191, 255});
        hashMap.put("dimgray", new Integer[]{105, 105, 105});
        hashMap.put("dimgrey", new Integer[]{105, 105, 105});
        hashMap.put("dodgerblue", new Integer[]{30, 144, 255});
        hashMap.put("firebrick", new Integer[]{178, 34, 34});
        hashMap.put("floralwhite", new Integer[]{255, 250, 240});
        hashMap.put("forestgreen", new Integer[]{34, 139, 34});
        hashMap.put("fuchsia", new Integer[]{255, 0, 255});
        hashMap.put("gainsboro", new Integer[]{220, 220, 220});
        hashMap.put("ghostwhite", new Integer[]{248, 248, 255});
        hashMap.put("gold", new Integer[]{255, 215, 0});
        hashMap.put("goldenrod", new Integer[]{218, 165, 32});
        hashMap.put("gray", new Integer[]{128, 128, 128});
        hashMap.put("green", new Integer[]{0, 128, 0});
        hashMap.put("greenyellow", new Integer[]{173, 255, 47});
        hashMap.put("grey", new Integer[]{128, 128, 128});
        hashMap.put("honeydew", new Integer[]{240, 255, 240});
        hashMap.put("hotpink", new Integer[]{255, 105, 180});
        hashMap.put("indianred", new Integer[]{205, 92, 92});
        hashMap.put("indigo", new Integer[]{75, 0, 130});
        hashMap.put("ivory", new Integer[]{255, 255, 240});
        hashMap.put("khaki", new Integer[]{240, 230, 140});
        hashMap.put("lavender", new Integer[]{230, 230, 250});
        hashMap.put("lavenderblush", new Integer[]{255, 240, 245});
        hashMap.put("lawngreen", new Integer[]{124, 252, 0});
        hashMap.put("lemonchiffon", new Integer[]{255, 250, 205});
        hashMap.put("lightblue", new Integer[]{173, 216, 230});
        hashMap.put("lightcoral", new Integer[]{240, 128, 128});
        hashMap.put("lightcyan", new Integer[]{224, 255, 255});
        hashMap.put("lightgoldenrodyellow", new Integer[]{250, 250, 210});
        hashMap.put("lightgray", new Integer[]{211, 211, 211});
        hashMap.put("lightgreen", new Integer[]{144, 238, 144});
        hashMap.put("lightgrey", new Integer[]{211, 211, 211});
        hashMap.put("lightpink", new Integer[]{255, 182, 193});
        hashMap.put("lightsalmon", new Integer[]{255, 160, 122});
        hashMap.put("lightseagreen", new Integer[]{32, 178, 170});
        hashMap.put("lightskyblue", new Integer[]{135, 206, 250});
        hashMap.put("lightslategray", new Integer[]{119, 136, 153});
        hashMap.put("lightslategrey", new Integer[]{119, 136, 153});
        hashMap.put("lightsteelblue", new Integer[]{176, 196, 222});
        hashMap.put("lightyellow", new Integer[]{255, 255, 224});
        hashMap.put("lime", new Integer[]{0, 255, 0});
        hashMap.put("limegreen", new Integer[]{50, 205, 50});
        hashMap.put("linen", new Integer[]{250, 240, 230});
        hashMap.put("magenta", new Integer[]{255, 0, 255});
        hashMap.put("maroon", new Integer[]{128, 0, 0});
        hashMap.put("mediumaquamarine", new Integer[]{102, 205, 170});
        hashMap.put("mediumblue", new Integer[]{0, 0, 205});
        hashMap.put("mediumorchid", new Integer[]{186, 85, 211});
        hashMap.put("mediumpurple", new Integer[]{147, 112, 219});
        hashMap.put("mediumseagreen", new Integer[]{60, 179, 113});
        hashMap.put("mediumslateblue", new Integer[]{123, 104, 238});
        hashMap.put("mediumspringgreen", new Integer[]{0, 250, 154});
        hashMap.put("mediumturquoise", new Integer[]{72, 209, 204});
        hashMap.put("mediumvioletred", new Integer[]{199, 21, 133});
        hashMap.put("midnightblue", new Integer[]{25, 25, 112});
        hashMap.put("mintcream", new Integer[]{245, 255, 250});
        hashMap.put("mistyrose", new Integer[]{255, 228, 225});
        hashMap.put("moccasin", new Integer[]{255, 228, 181});
        hashMap.put("navajowhite", new Integer[]{255, 222, 173});
        hashMap.put("navy", new Integer[]{0, 0, 128});
        hashMap.put("oldlace", new Integer[]{253, 245, 230});
        hashMap.put("olive", new Integer[]{128, 128, 0});
        hashMap.put("olivedrab", new Integer[]{107, 142, 35});
        hashMap.put("orange", new Integer[]{255, 165, 0});
        hashMap.put("orangered", new Integer[]{255, 69, 0});
        hashMap.put("orchid", new Integer[]{218, 112, 214});
        hashMap.put("palegoldenrod", new Integer[]{238, 232, 170});
        hashMap.put("palegreen", new Integer[]{152, 251, 152});
        hashMap.put("paleturquoise", new Integer[]{175, 238, 238});
        hashMap.put("palevioletred", new Integer[]{219, 112, 147});
        hashMap.put("papayawhip", new Integer[]{255, 239, 213});
        hashMap.put("peachpuff", new Integer[]{255, 218, 185});
        hashMap.put("peru", new Integer[]{205, 133, 63});
        hashMap.put("pink", new Integer[]{255, 192, 203});
        hashMap.put("plum", new Integer[]{221, 160, 221});
        hashMap.put("powderblue", new Integer[]{176, 224, 230});
        hashMap.put("purple", new Integer[]{128, 0, 128});
        hashMap.put("red", new Integer[]{255, 0, 0});
        hashMap.put("rosybrown", new Integer[]{188, 143, 143});
        hashMap.put("royalblue", new Integer[]{65, 105, 225});
        hashMap.put("saddlebrown", new Integer[]{139, 69, 19});
        hashMap.put("salmon", new Integer[]{250, 128, 114});
        hashMap.put("sandybrown", new Integer[]{244, 164, 96});
        hashMap.put("seagreen", new Integer[]{46, 139, 87});
        hashMap.put("seashell", new Integer[]{255, 245, 238});
        hashMap.put("sienna", new Integer[]{160, 82, 45});
        hashMap.put("silver", new Integer[]{192, 192, 192});
        hashMap.put("skyblue", new Integer[]{135, 206, 235});
        hashMap.put("slateblue", new Integer[]{106, 90, 205});
        hashMap.put("slategray", new Integer[]{112, 128, 144});
        hashMap.put("slategrey", new Integer[]{112, 128, 144});
        hashMap.put("snow", new Integer[]{255, 250, 250});
        hashMap.put("springgreen", new Integer[]{0, 255, 127});
        hashMap.put("steelblue", new Integer[]{70, 130, 180});
        hashMap.put("tan", new Integer[]{210, 180, 140});
        hashMap.put("teal", new Integer[]{0, 128, 128});
        hashMap.put("thistle", new Integer[]{216, 191, 216});
        hashMap.put("tomato", new Integer[]{255, 99, 71});
        hashMap.put("turquoise", new Integer[]{64, 224, 208});
        hashMap.put("violet", new Integer[]{238, 130, 238});
        hashMap.put("wheat", new Integer[]{245, 222, 179});
        hashMap.put("white", new Integer[]{255, 255, 255});
        hashMap.put("whitesmoke", new Integer[]{245, 245, 245});
        hashMap.put("yellow", new Integer[]{255, 255, 0});
        hashMap.put("yellowgreen", new Integer[]{154, 205, 50});
        return hashMap;
    }

    public void parse() throws IOException {
        if (this.styledText == null || "".equals(this.styledText.getText().trim())) {
            return;
        }
        this.initBeforeParsing();
        String string = this.styledText.getText().trim();
        int n = string.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                bl = true;
                continue;
            }
            if (c == '>') {
                bl = false;
                this.handleTag();
                this.currentTag.delete(0, this.currentTag.length());
                continue;
            }
            if (bl) {
                this.currentTag.append(c);
                continue;
            }
            ++this.currentPosition;
            this.output.append(c);
        }
        this.styledText.setText(this.output.toString());
        this.styledText.setStyleRanges(this.listOfStyles.toArray(new StyleRange[this.listOfStyles.size()]));
    }

    private void initBeforeParsing() {
        this.output = new StringBuilder();
        this.currentTag = new StringBuilder();
        this.listOfStyles.clear();
        this.stack.clear();
        this.currentPosition = 0;
    }

    private void handleTag() {
        String[] stringArray;
        String string = this.currentTag.toString().toLowerCase();
        if ("br".equals(string) || "br/".equals(string)) {
            this.output.append("\n");
            ++this.currentPosition;
            return;
        }
        if ("b".equals(string)) {
            this.processBeginBold();
            return;
        }
        if ("i".equals(string)) {
            this.processBeginItalic();
            return;
        }
        if ("u".equals(string)) {
            this.processBeginUnderline();
            return;
        }
        if (string.startsWith("size=")) {
            this.processBeginSize();
            return;
        }
        if (string.startsWith("color=")) {
            this.processBeginColor();
            return;
        }
        if (string.startsWith("backgroundcolor=")) {
            this.processBeginBackgroundColor();
            return;
        }
        for (String string2 : stringArray = new String[]{"/b", "/i", "/u", "/size", "/color", "/backgroundcolor"}) {
            if (!string2.equals(string)) continue;
            this.processEndTag(string2);
            return;
        }
        throw new RuntimeException("Tag <" + string + "/> not recognized");
    }

    private void processBeginBold() {
        StyleRange styleRange = new StyleRange();
        styleRange.start = this.currentPosition;
        styleRange.length = 0;
        styleRange.fontStyle = 1;
        styleRange.data = "</b>";
        this.stack.push(styleRange);
    }

    private void processEndTag(String string) {
        StyleRange styleRange = this.stack.pop();
        String string2 = "<" + string + ">";
        if (!string2.equals(styleRange.data)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error at position #").append(this.currentPosition).append(" - closing ").append(string2).append(" tag found but ");
            stringBuilder.append(styleRange.data).append(" tag expected !");
            throw new RuntimeException(stringBuilder.toString());
        }
        styleRange.length = this.currentPosition - styleRange.start;
        this.listOfStyles.add(styleRange);
    }

    private void processBeginItalic() {
        StyleRange styleRange = new StyleRange();
        styleRange.start = this.currentPosition;
        styleRange.length = 0;
        styleRange.fontStyle = 2;
        styleRange.data = "</i>";
        this.stack.push(styleRange);
    }

    private void processBeginUnderline() {
        StyleRange styleRange = new StyleRange();
        styleRange.start = this.currentPosition;
        styleRange.length = 0;
        styleRange.fontStyle = 0;
        styleRange.underline = true;
        styleRange.data = "</u>";
        this.stack.push(styleRange);
    }

    private void processBeginSize() {
        StyleRange styleRange = new StyleRange();
        styleRange.start = this.currentPosition;
        styleRange.length = 0;
        styleRange.fontStyle = 0;
        styleRange.font = this.computeFont();
        styleRange.data = "</size>";
        this.stack.push(styleRange);
    }

    private Font computeFont() {
        int n;
        String string = this.currentTag.toString().toLowerCase().replace("size=", "");
        if (string.length() == 0) {
            throw new RuntimeException("Argument size is empty !");
        }
        int n2 = this.defaultHeight;
        if (string.startsWith("+")) {
            n = Integer.valueOf(string.substring(1));
            n2 += n;
        } else if (string.startsWith("-")) {
            n = Integer.valueOf(string.substring(1));
            n2 -= n;
        }
        FontData fontData = this.styledText.getFont().getFontData()[0];
        final Font font = new Font((Device)this.styledText.getDisplay(), fontData.getName(), n2, 0);
        this.styledText.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                font.dispose();
            }
        });
        return font;
    }

    private void processBeginColor() {
        StyleRange styleRange = new StyleRange();
        styleRange.start = this.currentPosition;
        styleRange.length = 0;
        styleRange.fontStyle = 0;
        styleRange.foreground = this.computeColor();
        styleRange.data = "</color>";
        this.stack.push(styleRange);
    }

    private Color computeColor() {
        int n;
        int n2;
        int n3;
        Object[] objectArray;
        String string = this.currentTag.toString().toLowerCase().replace("color=", "").replace("background", "");
        if (string.length() == 0) {
            throw new RuntimeException("Argument color is empty !");
        }
        if (string.startsWith("#")) {
            objectArray = string.substring(1);
            if (objectArray.length() != 6) {
                throw new RuntimeException("Argument [" + (String)objectArray + "] is not valid !");
            }
            try {
                n3 = Integer.parseInt(objectArray.substring(0, 2).toLowerCase(), 16);
                n2 = Integer.parseInt(objectArray.substring(2, 4).toLowerCase(), 16);
                n = Integer.parseInt(objectArray.substring(4, 6).toLowerCase(), 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Argument [" + (String)objectArray + "] is not valid !");
            }
        } else if (string.indexOf(44) > -1) {
            objectArray = string.split(",");
            if (objectArray.length != 3) {
                throw new RuntimeException("Argument [" + string + "] is not valid !");
            }
            try {
                n3 = Integer.parseInt((String)objectArray[0]);
                n2 = Integer.parseInt((String)objectArray[1]);
                n = Integer.parseInt((String)objectArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Argument [" + string + "] is not valid !");
            }
        } else {
            objectArray = HTML_CODES.get(string.toLowerCase());
            if (objectArray == null) {
                n3 = 0;
                n2 = 0;
                n = 0;
            } else {
                n3 = (Integer)objectArray[0];
                n2 = (Integer)objectArray[1];
                n = (Integer)objectArray[2];
            }
        }
        objectArray = new Color((Device)this.styledText.getDisplay(), n3, n2, n);
        this.styledText.addListener(12, new Listener((Color)objectArray){
            final /* synthetic */ Color val$color;
            {
                this.val$color = color;
            }

            public void handleEvent(Event event) {
                this.val$color.dispose();
            }
        });
        return objectArray;
    }

    private void processBeginBackgroundColor() {
        StyleRange styleRange = new StyleRange();
        styleRange.start = this.currentPosition;
        styleRange.length = 0;
        styleRange.fontStyle = 0;
        styleRange.background = this.computeColor();
        styleRange.data = "</backgroundcolor>";
        this.stack.push(styleRange);
    }
}

