/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.roundedToolbar;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.mihalis.opal.roundedToolbar.RoundedToolbar;
import org.mihalis.opal.utils.AdvancedPath;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class RoundedToolItem
extends Item {
    private static final int MARGIN = 4;
    private static Color START_GRADIENT_COLOR = SWTGraphicUtil.getColorSafely(70, 70, 70);
    private static Color END_GRADIENT_COLOR = SWTGraphicUtil.getColorSafely(116, 116, 116);
    private final RoundedToolbar parentToolbar;
    private final List<SelectionListener> selectionListeners;
    private Rectangle bounds;
    private boolean enabled;
    private boolean selection;
    private int width;
    private int height;
    private Image disabledImage;
    private Image selectionImage;
    private int alignment;
    private Color textColorSelected;
    private Color textColor;
    private String tooltipText;
    private GC gc;
    private int toolbarHeight;
    private boolean isLast;

    public RoundedToolItem(RoundedToolbar roundedToolbar) {
        this(roundedToolbar, 0);
    }

    public RoundedToolItem(RoundedToolbar roundedToolbar, int n) {
        super((Widget)roundedToolbar, n);
        roundedToolbar.addItem(this);
        this.parentToolbar = roundedToolbar;
        this.textColor = roundedToolbar.getDisplay().getSystemColor(2);
        this.textColorSelected = roundedToolbar.getDisplay().getSystemColor(1);
        this.enabled = true;
        this.alignment = 0x1000000;
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.width = -1;
        this.height = -1;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.add(selectionListener);
    }

    Point computeDefaultSize() {
        Point point = this.computeSizeOfTextAndImages();
        return new Point(8 + point.x, 8 + point.y);
    }

    private Point computeSizeOfTextAndImages() {
        GC gC;
        boolean bl;
        int n = 0;
        int n2 = 0;
        boolean bl2 = bl = this.getText() != null && !this.getText().equals("");
        if (bl) {
            gC = new GC((Drawable)this.parentToolbar);
            Point point = gC.stringExtent(this.getText());
            gC.dispose();
            n += point.x;
            n2 = point.y;
        }
        gC = new Point(-1, -1);
        this.computeImageSize(this.getImage(), (Point)gC);
        this.computeImageSize(this.selectionImage, (Point)gC);
        this.computeImageSize(this.disabledImage, (Point)gC);
        if (gC.x != -1) {
            n += gC.x;
            n2 = Math.max(gC.y, n2);
            if (bl) {
                n += 4;
            }
        }
        return new Point(n, n2);
    }

    private void computeImageSize(Image image, Point point) {
        if (image == null) {
            return;
        }
        Rectangle rectangle = image.getBounds();
        point.x = Math.max(rectangle.width, point.x);
        point.y = Math.max(rectangle.height, point.y);
    }

    public void dispose() {
        this.selectionListeners.clear();
        this.getParent().removeItem(this);
        this.bounds = null;
        this.disabledImage = null;
        this.selectionImage = null;
        this.textColor = null;
        this.textColorSelected = null;
        super.dispose();
    }

    void drawButton(GC gC, int n, int n2, boolean bl) {
        this.gc = gC;
        this.toolbarHeight = n2;
        this.isLast = bl;
        if (this.selection) {
            this.drawBackground(n);
        }
        if (!bl) {
            this.drawRightLine(n);
        }
        int n3 = this.computeStartingPosition(n);
        n3 += this.drawImage(n + n3);
        this.drawText(n + n3);
        this.bounds = new Rectangle(n, 0, this.getWidth(), n2);
    }

    private void drawBackground(int n) {
        boolean bl;
        AdvancedPath advancedPath = new AdvancedPath((Device)this.getDisplay());
        boolean bl2 = bl = this.getParent().indexOf(this) == 0;
        if (bl) {
            advancedPath.addRoundRectangleStraightRight(n, 0.0f, this.getWidth(), this.toolbarHeight, this.parentToolbar.getCornerRadius(), this.parentToolbar.getCornerRadius());
        } else if (this.isLast) {
            advancedPath.addRoundRectangleStraightLeft(n, 0.0f, this.getWidth(), this.toolbarHeight, this.parentToolbar.getCornerRadius(), this.parentToolbar.getCornerRadius());
        } else {
            advancedPath.addRectangle(n, 0.0f, this.getWidth(), this.toolbarHeight);
        }
        this.gc.setClipping((Path)advancedPath);
        this.gc.setForeground(START_GRADIENT_COLOR);
        this.gc.setBackground(END_GRADIENT_COLOR);
        this.gc.fillGradientRectangle(n, 0, this.getWidth() + this.parentToolbar.getCornerRadius(), this.toolbarHeight, true);
        this.gc.setClipping((Rectangle)null);
    }

    private void drawRightLine(int n) {
        this.gc.setForeground(RoundedToolbar.BORDER_COLOR);
        this.gc.drawLine(n + this.getWidth(), 0, n + this.getWidth(), this.toolbarHeight);
    }

    private int computeStartingPosition(int n) {
        int n2 = this.computeSizeOfTextAndImages().x;
        switch (this.alignment) {
            case 0x1000000: {
                return (this.getWidth() - n2) / 2;
            }
            case 131072: {
                return this.getWidth() - n2 - 4;
            }
        }
        return 4;
    }

    void fireSelectionEvent() {
        Event event = new Event();
        event.widget = this.parentToolbar;
        event.display = this.getDisplay();
        event.item = this;
        event.type = 13;
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.widgetSelected(new SelectionEvent(event));
        }
    }

    private int drawImage(int n) {
        Image image = !this.isEnabled() ? this.disabledImage : (this.selection ? this.selectionImage : this.getImage());
        if (image == null) {
            return 0;
        }
        int n2 = (this.toolbarHeight - image.getBounds().height) / 2;
        this.gc.drawImage(image, n, n2);
        return image.getBounds().width + 4;
    }

    private void drawText(int n) {
        this.gc.setFont(this.parentToolbar.getFont());
        if (this.selection) {
            this.gc.setForeground(this.textColorSelected);
        } else {
            this.gc.setForeground(this.textColor);
        }
        Point point = this.gc.stringExtent(this.getText());
        int n2 = (this.toolbarHeight - point.y) / 2;
        this.gc.drawText(this.getText(), n, n2, true);
    }

    public int getAlignment() {
        this.checkWidget();
        return this.alignment;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.bounds;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this.enabled;
    }

    public int getHeight() {
        this.checkWidget();
        if (this.height == -1) {
            return this.computeDefaultSize().y;
        }
        return this.height;
    }

    public RoundedToolbar getParent() {
        this.checkWidget();
        return this.parentToolbar;
    }

    public boolean getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public Image getSelectionImage() {
        this.checkWidget();
        return this.selectionImage;
    }

    public Color getTextColor() {
        this.checkWidget();
        return this.textColor;
    }

    public Color getTextColorSelected() {
        this.checkWidget();
        return this.textColorSelected;
    }

    public String getTooltipText() {
        this.checkWidget();
        return this.tooltipText;
    }

    public int getWidth() {
        this.checkWidget();
        if (this.width == -1) {
            return this.computeDefaultSize().x;
        }
        return this.width;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.enabled;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.remove(selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        this.alignment = n;
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (this.bounds == null) {
            SWT.error((int)4);
        }
        this.bounds = new Rectangle(Math.max(0, rectangle.x), Math.max(0, rectangle.y), Math.max(0, rectangle.width), Math.max(0, rectangle.height));
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        this.disabledImage = image;
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        this.enabled = bl;
    }

    public void setHeight(int n) {
        this.checkWidget();
        this.height = Math.max(n, 0);
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        this.selection = bl;
    }

    public void setSelectionImage(Image image) {
        this.checkWidget();
        this.selectionImage = image;
    }

    public void setTextColor(Color color) {
        this.checkWidget();
        this.textColor = color;
    }

    public void setTextColorSelected(Color color) {
        this.checkWidget();
        this.textColorSelected = color;
    }

    public void setTooltipText(String string) {
        this.checkWidget();
        this.tooltipText = string == null ? "" : string;
    }

    public void setWidth(int n) {
        this.checkWidget();
        this.width = Math.max(0, n);
    }
}

