/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.preferenceWindow;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.mihalis.opal.preferenceWindow.PWContainer;
import org.mihalis.opal.preferenceWindow.PWGroup;
import org.mihalis.opal.preferenceWindow.PWRow;
import org.mihalis.opal.preferenceWindow.PWRowGroup;
import org.mihalis.opal.preferenceWindow.PreferenceWindow;
import org.mihalis.opal.preferenceWindow.widgets.PWWidget;

public class PWTab
extends PWContainer {
    private final Image image;
    private final String text;
    private final List<PWRowGroup> children;

    PWTab(Image image, String string) {
        this.image = image;
        this.text = string;
        this.children = new ArrayList<PWRowGroup>();
    }

    @Override
    public PWContainer add(PWContainer pWContainer) {
        if (!(pWContainer instanceof PWGroup) && !(pWContainer instanceof PWRow)) {
            throw new UnsupportedOperationException("Can only add a PWGroup or a PWRow.");
        }
        ((PWRowGroup)pWContainer).setParent(this);
        this.children.add((PWRowGroup)pWContainer);
        return this;
    }

    @Override
    public PWContainer add(PWWidget pWWidget) {
        PWRow pWRow = new PWRow();
        pWRow.setParent(this);
        pWRow.add(pWWidget);
        this.children.add(pWRow);
        return this;
    }

    @Override
    public void build(Composite composite) {
        int n = this.computeNumberOfColums();
        composite.setLayout((Layout)new GridLayout(n, false));
        for (PWRowGroup pWRowGroup : this.children) {
            pWRowGroup.setParentNumberOfColumns(n);
            pWRowGroup.build(composite);
        }
        PreferenceWindow.getInstance().fireEnablers();
    }

    private int computeNumberOfColums() {
        int n = 1;
        for (PWRowGroup pWRowGroup : this.children) {
            if (!(pWRowGroup instanceof PWRow)) continue;
            n = Math.max(n, pWRowGroup.getNumberOfColums());
        }
        return n;
    }

    public Image getImage() {
        return this.image;
    }

    public String getText() {
        return this.text;
    }
}

