/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.holders;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CommandHolder {
    INSTANCE;

    private static final Logger log;

    static {
        log = LoggerFactory.getLogger(CommandHolder.class);
    }

    public void executeCommand(String commandId, Object parameter) {
        try {
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
            Event event = new Event();
            event.data = parameter;
            handlerService.executeCommand(commandId, event);
        }
        catch (NotDefinedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotEnabledException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotHandledException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

