/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.discount;

import java.io.File;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.domain.HierarchicalPicklist;
import ru.ssa.cashadmin.domain.Invent;
import su.artix.cashserver.security.SecurityKey;
import su.artix.widgets.DualSelectionAdapter;
import su.artix.widgets.TextWithClearButton;
import su.artix.yuki.binding.BindingKey;
import su.artix.yuki.binding.BindingType;
import su.artix.yuki.editors.DirectoryChoiceSelectionAdapter;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.view.Base64ImageExtractor;

@SecurityKey(title="\u041a\u0430\u0442\u0430\u043b\u043e\u0433")
public class HierarchicalPicklistEditPanel
extends EditorComposite<HierarchicalPicklist> {
    private static final Logger log = LoggerFactory.getLogger(HierarchicalPicklistEditPanel.class);
    @SecurityKey(title="ID", id="code")
    private Label codeLabel;
    @SecurityKey(id="code")
    private Text codeField;
    @SecurityKey(title="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", id="name")
    private Label nameLabel;
    @SecurityKey(id="name")
    private Text nameField;
    @SecurityKey(title="\u0418\u0437\u043e\u0431\u0430\u0440\u0436\u0435\u043d\u0438\u0435", id="image")
    private Label imageLabel;
    @SecurityKey(id="image")
    @BindingKey(bindingType=BindingType.IMAGE)
    private Label imageField;
    @SecurityKey(title="\u0422\u043e\u0432\u0430\u0440", id="tmc")
    private Label inventLabel;
    @SecurityKey(id="tmc")
    @BindingKey(subField="name")
    private TextWithClearButton inventField;
    @SecurityKey(title="\u041f\u043e\u0440\u044f\u0434\u043e\u043a", id="itemorder")
    private Label orderLabel;
    @SecurityKey(id="itemorder")
    private Spinner orderField;

    private HierarchicalPicklistEditPanel(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public HierarchicalPicklistEditPanel(Composite parent, int style, HierarchicalPicklist model) {
        super(parent, style, HierarchicalPicklist.class, (Object)model);
    }

    public void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.codeLabel = new Label((Composite)this, 0);
        this.codeLabel.setText("ID:");
        this.codeField = new Text((Composite)this, 2048);
        this.codeField.setLayoutData((Object)new GridData(4, 0, true, false));
        this.nameLabel = new Label((Composite)this, 0);
        this.nameLabel.setText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:");
        this.nameField = new Text((Composite)this, 2048);
        this.nameField.setLayoutData((Object)new GridData(4, 0, true, false));
        this.inventLabel = new Label((Composite)this, 0);
        this.inventLabel.setText("\u0422\u043e\u0432\u0430\u0440:");
        this.inventField = new TextWithClearButton((Composite)this, 0);
        this.inventField.addSelectionListener((DualSelectionAdapter)new DirectoryChoiceSelectionAdapter(this.getShell(), (Widget)this.inventField.getSelectButtonControl(), this.getModel(), "tmc", Invent.class));
        this.inventLabel.setVisible(!((HierarchicalPicklist)this.getModel()).isHasChildren());
        this.inventField.setVisible(!((HierarchicalPicklist)this.getModel()).isHasChildren());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.inventField);
        this.orderLabel = new Label((Composite)this, 0);
        this.orderLabel.setText("\u041f\u043e\u0440\u044f\u0434\u043e\u043a:");
        this.orderField = new Spinner((Composite)this, 2048);
        this.orderField.setMaximum(Integer.MAX_VALUE);
        this.orderField.setLayoutData((Object)new GridData(4, 0, true, false));
        this.imageLabel = new Label((Composite)this, 0);
        this.imageLabel.setText("\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435:");
        Composite compositeImageButton = new Composite((Composite)this, 0);
        GridLayout gridLayoutImageBtn = new GridLayout();
        gridLayoutImageBtn.numColumns = 2;
        compositeImageButton.setLayout((Layout)gridLayoutImageBtn);
        Button button = new Button(compositeImageButton, 8);
        button.setText("\u0412\u044b\u0431\u0440\u0430\u0442\u044c  \u0444\u0430\u0439\u043b (\u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 48\u041a\u0411) ...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String path = HierarchicalPicklistEditPanel.openDialogsForSelectImage((Shell)HierarchicalPicklistEditPanel.this.getShell());
                if (path != null) {
                    try {
                        File curFile = new File(path);
                        if (curFile != null && curFile.length() > 49152L) {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430", (String)"\u0420\u0430\u0437\u043c\u0435\u0440 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0435\u0442 48\u041a\u0411");
                        } else {
                            String data = DatatypeConverter.printBase64Binary((byte[])FileUtils.readFileToByteArray((File)curFile));
                            HierarchicalPicklistEditPanel.this.setImage(data);
                        }
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
        Button delImmageBtn = new Button(compositeImageButton, 8);
        delImmageBtn.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435");
        delImmageBtn.setImage(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/delete").createImage());
        delImmageBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HierarchicalPicklistEditPanel.this.setImage(null);
            }
        });
        new Label((Composite)this, 0);
        this.imageField = new Label((Composite)this, 0);
        this.imageField.setSize(new Point(500, 500));
        this.setLayout((Layout)gridLayout);
    }

    private void setImage(String imageData) {
        ((HierarchicalPicklist)this.getModel()).setImage(StringUtils.defaultString((String)imageData));
        this.imageField.setImage(new Base64ImageExtractor().getImage(imageData));
        this.imageField.pack();
        this.imageField.redraw();
    }

    public void initDefault(HierarchicalPicklist model) {
        super.initDefault((Object)model);
        model.setImage("");
    }

    public void bindValues() {
        this.initDefaulBinding();
    }
}

