/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.goods;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import ru.ssa.artixadmin.editors.directory.goods.InventEditDialog;
import ru.ssa.artixadmin.editors.directory.goods.InventEditPanel;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Aspectscheme;
import ru.ssa.cashadmin.domain.Barcodes;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.domain.InventGroup;
import su.artix.cashserver.security.SecurityKey;
import su.artix.discountmanager.Activator;
import su.artix.widgets.BitCheckGroup;
import su.artix.widgets.ComboBoxWithEmptyBox;
import su.artix.widgets.DualSelectionAdapter;
import su.artix.widgets.TextWithClearButton;
import su.artix.yuki.binding.BindingKey;
import su.artix.yuki.binding.BindingType;
import su.artix.yuki.directory.Directory;
import su.artix.yuki.directory.DirectoryLabelProvider;
import su.artix.yuki.directory.DirectoryList;
import su.artix.yuki.directory.MyKeyValue;
import su.artix.yuki.editors.DirectoryChoiceSelectionAdapter;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.model.ModelActivator;

@SecurityKey(title="\u0422\u043e\u0432\u0430\u0440\u044b (\u0431\u0430\u0437\u043e\u0432\u0430\u044f)", parent=InventEditPanel.class)
public class InventBasicEditPanel
extends EditorComposite<Invent> {
    private static final Logger log = LoggerFactory.getLogger(InventBasicEditPanel.class);
    @SecurityKey(title="\u041a\u043e\u0434", id="code")
    private Label codeLabel;
    @SecurityKey(id="code")
    private Text codeField;
    @SecurityKey(title="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", id="name")
    private Label nameLabel;
    @SecurityKey(id="name")
    private Text nameField;
    @SecurityKey(title="\u0410\u0440\u0442\u0438\u043a\u0443\u043b", id="articul")
    private Label articulLabel;
    @SecurityKey(id="articul")
    private Text articulField;
    @SecurityKey(title="\u041a\u043e\u0434 \u0430\u043b\u043a\u043e\u0433\u043e\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0446\u0438\u0438", id="alctypecode")
    private Label alctypecodeLabel;
    @SecurityKey(id="alctypecode")
    private Spinner alctypecodeField;
    @SecurityKey(title="\u0413\u0440\u0443\u043f\u043f\u0430", id="group")
    private Label groupLabel;
    @SecurityKey(id="group")
    @BindingKey(subField="groupname")
    private TextWithClearButton groupField;
    @SecurityKey(title="\u0421\u0445\u0435\u043c\u0430 \u0440\u0430\u0437\u0440\u0435\u0437\u043e\u0432", id="aspectscheme")
    private Label aspectschemeLabel;
    @SecurityKey(id="aspectscheme")
    @BindingKey(subField="aspectschemename")
    private TextWithClearButton aspectschemeField;
    @SecurityKey(title="\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u0430\u043b\u043a\u043e\u0433\u043e\u043b\u044f", id="alcoholpercent")
    private Label alcoholpercentLabel;
    @SecurityKey(id="alcoholpercent")
    @BindingKey(bindingType=BindingType.ALCOHOL)
    private Spinner alcoholpercentField;
    @SecurityKey(title="\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0432\u043e\u0437\u0440\u0430\u0441\u0442 \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f", id="age")
    private Label ageLabel;
    @SecurityKey(id="age")
    private Spinner ageField;
    @SecurityKey(title="\u0418\u041d\u041d \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f", id="inn")
    private Label innLabel;
    @SecurityKey(id="inn")
    private Text innField;
    @SecurityKey(title="\u041a\u041f\u041f \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f", id="kpp")
    private Label kppLabel;
    @SecurityKey(id="kpp")
    private Text kppField;
    @SecurityKey(title="\u041d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u043b\u0430\u0441\u0441\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", id="ntin")
    private Label ntinLabel;
    @SecurityKey(id="ntin")
    private Text ntinField;
    @SecurityKey(title="\u041a\u043e\u0434 \u0443\u043f\u0430\u043a\u043e\u0432\u043a\u0438", id="packagecode")
    private Label packagecodeLabel;
    @SecurityKey(id="packagecode")
    private Text packagecodeField;
    @SecurityKey(title="\u0412\u0432\u043e\u0434 \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434", id="bcodeMode")
    private BitCheckGroup bcodeModeField;
    @SecurityKey(id="gtin")
    @BindingKey(ignore=true)
    private Button gtinField;
    @SecurityKey(id="gtinCombo")
    @BindingKey(ignore=true)
    private ComboViewer gtinCombo;
    @SecurityKey(id="packageCodeBtn")
    @BindingKey(ignore=true)
    private Button packageCodeBtn;
    @SecurityKey(id="packageCodeCombo")
    @BindingKey(ignore=true)
    private ComboViewer packageCodeCombo;
    @SecurityKey(title="\u0422\u0438\u043f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430/\u0443\u0441\u043b\u0443\u0433\u0438", id="ownertype")
    private Label ownertypeLabel;
    @SecurityKey(id="ownertype")
    @BindingKey(bindingType=BindingType.DIRECTORY_LIST_INTEGER)
    private ComboBoxWithEmptyBox ownertypeComboBox;
    private final int alcoholDigit = 2;
    private final boolean enableGtinButton;
    private final boolean enablePackagecodeButton;
    private final String gtinUrl;
    private final String mxikUrl;
    private final RestTemplate restTemplate;

    public InventBasicEditPanel(Composite parent, int style, Invent model) {
        super(parent, style, Invent.class, (Object)model);
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.enableGtinButton = preferenceStore.getBoolean("ENABLE_GTIN_BUTTON");
        this.enablePackagecodeButton = preferenceStore.getBoolean("ENABLE_PACKAGE_CODE_BUTTON");
        this.gtinUrl = preferenceStore.getString("GTIN_URL");
        this.mxikUrl = preferenceStore.getString("PACKAGE_CODE_URL");
        this.restTemplate = new RestTemplate();
        ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setSupportedMediaTypes(Collections.singletonList(MediaType.ALL));
        messageConverters.add(converter);
        this.restTemplate.setMessageConverters(messageConverters);
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory(){

            protected void prepareConnection(HttpURLConnection connection, String httpMethod) throws IOException {
                if (connection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)connection).setHostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String hostname, SSLSession session) {
                            return true;
                        }
                    });
                }
                super.prepareConnection(connection, httpMethod);
            }
        });
    }

    public void initialize() {
        Label nameLabel;
        GridLayoutFactory.swtDefaults().numColumns(4).applyTo((Composite)this);
        this.codeLabel = new Label((Composite)this, 0);
        this.codeLabel.setText("\u041a\u043e\u0434 \u0442\u043e\u0432\u0430\u0440\u0430:");
        this.codeField = new Text((Composite)this, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.codeField);
        this.codeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ((Invent)InventBasicEditPanel.this.getModel()).setBcode(InventBasicEditPanel.this.codeField.getText());
            }
        });
        if (this.enableGtinButton) {
            nameLabel = new Label((Composite)this, 0);
            nameLabel.setText("\u0422\u043e\u0432\u0430\u0440 \u0438\u0437 GS1:");
            this.gtinField = new Button((Composite)this, 8);
            this.gtinField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    super.widgetSelected(event);
                    try {
                        DirectoryList names = InventBasicEditPanel.this.getMxikCodes();
                        if (!names.isEmpty()) {
                            InventBasicEditPanel.this.gtinCombo.setInput((Object)names);
                            InventBasicEditPanel.this.gtinCombo.setSelection((ISelection)new StructuredSelection(names.get(0)), true);
                        }
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
            this.gtinField.setText("\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 GS1");
            GridDataFactory.fillDefaults().grab(false, false).span(1, 1).applyTo((Control)this.gtinField);
            this.gtinCombo = new ComboViewer((Composite)this, 8);
            this.gtinCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.gtinCombo.setLabelProvider((IBaseLabelProvider)new DirectoryLabelProvider());
            GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo(this.gtinCombo.getControl());
            this.gtinCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MyKeyValue keyValue = (MyKeyValue)((StructuredSelection)event.getSelection()).getFirstElement();
                    if (keyValue != null) {
                        InventBasicEditPanel.this.ntinField.setText(keyValue.getKey().toString());
                        InventBasicEditPanel.this.nameField.setText(keyValue.getValue().toString());
                    }
                }
            });
        }
        this.nameLabel = new Label((Composite)this, 0);
        this.nameLabel.setText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u043e\u0432\u0430\u0440\u0430:");
        this.nameField = new Text((Composite)this, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.nameField);
        this.articulLabel = new Label((Composite)this, 0);
        this.articulLabel.setText("\u0410\u0440\u0442\u0438\u043a\u0443\u043b:");
        this.articulField = new Text((Composite)this, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.articulField);
        this.alctypecodeLabel = new Label((Composite)this, 0);
        this.alctypecodeLabel.setText("\u041a\u043e\u0434 \u0430\u043b\u043a\u043e\u0433\u043e\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0446\u0438\u0438:");
        this.alctypecodeField = new Spinner((Composite)this, 2048);
        this.alctypecodeField.setMaximum(Integer.MAX_VALUE);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.alctypecodeField);
        this.alcoholpercentLabel = new Label((Composite)this, 0);
        this.alcoholpercentLabel.setText("\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u0430\u043b\u043a\u043e\u0433\u043e\u043b\u044f:");
        this.alcoholpercentField = new Spinner((Composite)this, 2048);
        this.alcoholpercentField.setMaximum(10000);
        this.alcoholpercentField.setDigits(2);
        this.alcoholpercentField.setIncrement((int)Math.pow(10.0, this.alcoholpercentField.getDigits()));
        this.alcoholpercentField.setPageIncrement((int)Math.pow(10.0, this.alcoholpercentField.getDigits() + 1));
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.alcoholpercentField);
        this.ageLabel = new Label((Composite)this, 0);
        this.ageLabel.setText("\u041c\u0438\u043d. \u0432\u043e\u0437\u0440\u0430\u0441\u0442 \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f:");
        this.ageField = new Spinner((Composite)this, 2048);
        this.ageField.setMaximum(200);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.ageField);
        this.innLabel = new Label((Composite)this, 0);
        this.innLabel.setText("\u0418\u041d\u041d \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f:");
        this.innField = new Text((Composite)this, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.innField);
        this.kppLabel = new Label((Composite)this, 0);
        this.kppLabel.setText("\u041a\u041f\u041f \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f:");
        this.kppField = new Text((Composite)this, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.kppField);
        this.groupLabel = new Label((Composite)this, 0);
        this.groupLabel.setText("\u0413\u0440\u0443\u043f\u043f\u0430:");
        this.groupField = new TextWithClearButton((Composite)this, 0);
        this.groupField.addSelectionListener((DualSelectionAdapter)new DirectoryChoiceSelectionAdapter(this.getShell(), (Widget)this.groupField.getSelectButtonControl(), this.getModel(), "group", InventGroup.class));
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.groupField);
        this.aspectschemeLabel = new Label((Composite)this, 0);
        this.aspectschemeLabel.setText("\u0421\u0445\u0435\u043c\u0430 \u0440\u0430\u0437\u0440\u0435\u0437\u043e\u0432:");
        this.aspectschemeField = new TextWithClearButton((Composite)this, 0);
        this.aspectschemeField.addSelectionListener((DualSelectionAdapter)new DirectoryChoiceSelectionAdapter(this.getShell(), (Widget)this.aspectschemeField.getSelectButtonControl(), this.getModel(), "aspectscheme", Aspectscheme.class));
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.aspectschemeField);
        this.ntinLabel = new Label((Composite)this, 0);
        this.ntinLabel.setText("\u041d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u043b\u0430\u0441\u0441\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440:");
        this.ntinField = new Text((Composite)this, 2048);
        this.ntinField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (InventBasicEditPanel.this.enableGtinButton) {
                    ((InventEditDialog)InventBasicEditPanel.this.getParentDialog()).setNtin(InventBasicEditPanel.this.ntinField.getText());
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.ntinField);
        if (this.enablePackagecodeButton) {
            nameLabel = new Label((Composite)this, 0);
            nameLabel.setText("\u0422\u043e\u0432\u0430\u0440 \u0438\u0437 MXIK:");
            this.packageCodeBtn = new Button((Composite)this, 8);
            this.packageCodeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    super.widgetSelected(event);
                    String ntin = InventBasicEditPanel.this.ntinField.getText();
                    log.info("get packageCode, for ntin: {}", (Object)ntin);
                    try {
                        log.info("PACKAGE_CODE_URL: {}", (Object)(String.valueOf(InventBasicEditPanel.this.mxikUrl) + ntin));
                        if (StringUtils.isNotEmpty((String)InventBasicEditPanel.this.mxikUrl)) {
                            ResponseEntity result = InventBasicEditPanel.this.restTemplate.getForEntity(String.valueOf(InventBasicEditPanel.this.mxikUrl) + ntin, Map.class, new Object[0]);
                            if (result.getStatusCode() == HttpStatus.OK) {
                                Integer recordTotal = (Integer)((Map)result.getBody()).get("recordTotal");
                                if (recordTotal > 0) {
                                    DirectoryList packageCodes = new DirectoryList();
                                    packageCodes.clear();
                                    for (Map d : (ArrayList)((Map)result.getBody()).get("data")) {
                                        packageCodes.add((Integer)d.get("code"), (String)d.get("nameUz"));
                                    }
                                    InventBasicEditPanel.this.packageCodeCombo.setInput((Object)packageCodes);
                                    InventBasicEditPanel.this.packageCodeCombo.setSelection((ISelection)new StructuredSelection(packageCodes.get(0)), true);
                                } else {
                                    log.error("{}", result.getBody());
                                }
                            } else {
                                log.error("{}", result.getBody());
                            }
                        } else {
                            log.info("PACKAGE_CODE_URL is empty");
                        }
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
            this.packageCodeBtn.setText("\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u0434 \u0443\u043f\u0430\u043a\u043e\u0432\u043a\u0438");
            GridDataFactory.fillDefaults().span(1, 1).grab(false, false).applyTo((Control)this.packageCodeBtn);
            this.packageCodeCombo = new ComboViewer((Composite)this, 8);
            this.packageCodeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.packageCodeCombo.setLabelProvider((IBaseLabelProvider)new DirectoryLabelProvider());
            GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo(this.packageCodeCombo.getControl());
            this.packageCodeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MyKeyValue keyValue = (MyKeyValue)((StructuredSelection)event.getSelection()).getFirstElement();
                    if (keyValue != null) {
                        InventBasicEditPanel.this.packagecodeField.setText(keyValue.getKey().toString());
                    }
                }
            });
        }
        this.packagecodeLabel = new Label((Composite)this, 0);
        this.packagecodeLabel.setText("\u041a\u043e\u0434 \u0443\u043f\u0430\u043a\u043e\u0432\u043a\u0438:");
        this.packagecodeField = new Text((Composite)this, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.packagecodeField);
        this.ownertypeLabel = new Label((Composite)this, 0);
        this.ownertypeLabel.setText("\u0422\u0438\u043f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430/\u0443\u0441\u043b\u0443\u0433\u0438:");
        this.ownertypeComboBox = new ComboBoxWithEmptyBox((Composite)this, 8);
        this.ownertypeComboBox.getComboBox().setContentProvider((IContentProvider)new ArrayContentProvider());
        this.ownertypeComboBox.getComboBox().setLabelProvider((IBaseLabelProvider)new DirectoryLabelProvider());
        this.ownertypeComboBox.getComboBox().setInput((Object)Directory.tmcOwnerType);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.ownertypeComboBox);
        this.bcodeModeField = new BitCheckGroup((Composite)this, 0, Directory.tmcBcodeModes);
        GridDataFactory.fillDefaults().span(4, 1).grab(true, false).applyTo((Control)this.bcodeModeField);
    }

    public DirectoryList getMxikCodes() {
        DirectoryList mxikCodesNames = new DirectoryList();
        String bcode = this.codeField.getText();
        log.info("get gtin data, for:{}", (Object)bcode);
        try {
            mxikCodesNames = this.getMxikCodesForBarcode(bcode);
            if (mxikCodesNames.isEmpty()) {
                Barcodes state = (Barcodes)LibActivator.getDefault().getActualClassResolver().getInstance(Barcodes.class);
                state.setCode(bcode);
                List objects = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Barcodes.class).getList((Object)state);
                for (Barcodes b : objects) {
                    DirectoryList namesTmp = this.getMxikCodesForBarcode(b.getBarcode());
                    if (namesTmp.isEmpty()) continue;
                    for (MyKeyValue kv : namesTmp) {
                        if (mxikCodesNames.contains((Object)kv)) continue;
                        mxikCodesNames.add((Object)kv);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return mxikCodesNames;
    }

    private DirectoryList getMxikCodesForBarcode(String bcode) {
        DirectoryList names = new DirectoryList();
        if (StringUtils.isNotEmpty((String)this.gtinUrl)) {
            log.info("gs1 url: {}", (Object)(String.valueOf(this.gtinUrl) + bcode));
            ResponseEntity result = this.restTemplate.getForEntity(String.valueOf(this.gtinUrl) + bcode, Map.class, new Object[0]);
            if (result.getStatusCode() == HttpStatus.OK) {
                if (BooleanUtils.toBoolean((Boolean)((Boolean)((Map)result.getBody()).get("success")))) {
                    Integer recordTotal = (Integer)((Map)result.getBody()).get("recordTotal");
                    if (recordTotal > 0) {
                        for (Map d : (ArrayList)((Map)result.getBody()).get("data")) {
                            names.add((String)d.get("mxik"), (String)d.get("name"));
                        }
                    }
                } else {
                    log.error("{}", result.getBody());
                }
            } else {
                log.error("{}", result.getBody());
            }
        } else {
            log.info("gs1 url is empty");
        }
        return names;
    }

    public boolean isValidNtin() {
        ResponseEntity result;
        log.info("PACKAGE_CODE_URL: {}", (Object)(String.valueOf(this.mxikUrl) + this.ntinField.getText()));
        if (StringUtils.isNotEmpty((String)this.mxikUrl) && StringUtils.isNotEmpty((String)this.ntinField.getText()) && (result = this.restTemplate.getForEntity(String.valueOf(this.mxikUrl) + this.ntinField.getText(), Map.class, new Object[0])).getStatusCode() == HttpStatus.OK) {
            Integer recordTotal = (Integer)((Map)result.getBody()).get("recordTotal");
            return recordTotal > 0;
        }
        return false;
    }

    public void bindValues() {
        this.initDefaulBinding();
    }

    public Invent getActualModel(Invent model) {
        return model;
    }
}

