/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.action;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.editors.directory.goods.InventSelectDialog;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.HotKeyInvent;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import ru.ssa.cashadmin.utils.AdditionalCriteria;
import su.artix.yuki.editors.DirectorySelectDialogState;
import su.artix.yuki.model.DuplicateValueException;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryEditModel;
import su.artix.yuki.view.DirectoryTableViewPanel;

public class HotKeyInventSelectDialog
extends InventSelectDialog {
    private static final Logger log = LoggerFactory.getLogger(HotKeyInventSelectDialog.class);
    private final HotKeyInvent model;

    public HotKeyInventSelectDialog(Shell parentShell, HotKeyInvent model, DirectorySelectDialogState selectDialogState) {
        super(parentShell, (Invent)LibActivator.getDefault().getActualClassResolver().getInstance(Invent.class), selectDialogState);
        this.model = model;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        ((DirectoryTableViewPanel)this.getViewPanel()).getFilter().setAdditionalCriteria(new AdditionalCriteria(AdditionalCriteria.Type.EQ_PROPERTY, new Object[]{"code", "bcode"}));
        return control;
    }

    protected void okPressed() {
        DirectoryEditModel directoryModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(HotKeyInvent.class);
        try {
            HotKeyInvent hotKeyInvent = (HotKeyInvent)LibActivator.getDefault().getActualClassResolver().getInstance(HotKeyInvent.class);
            hotKeyInvent.setHotkey(this.model.getHotkey());
            hotKeyInvent.setHotkeycode(this.model.getHotkeycode());
            hotKeyInvent.setInvent((Invent)this.getModel());
            hotKeyInvent.setInventcode(((Invent)this.getModel()).getCode());
            directoryModel.doAdd((Object)hotKeyInvent);
        }
        catch (DuplicateValueException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        super.okPressed();
    }
}

