/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.ApplicationWorkbenchWindowAdvisor;
import su.artix.discountmanager.Activator;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final String PERSPECTIVE_ID = "ru.ssa.artixadmin.Perspective";
    private static final Logger log = LoggerFactory.getLogger(ApplicationWorkbenchAdvisor.class);

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return PERSPECTIVE_ID;
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
        log.trace("getSaveAndRestore={}", (Object)configurer.getSaveAndRestore());
        IPerspectiveDescriptor[] ps = PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
        int i = 0;
        while (i < ps.length) {
            PlatformUI.getWorkbench().getPerspectiveRegistry().revertPerspective(ps[i]);
            ++i;
        }
    }

    public boolean preShutdown() {
        boolean bResult = super.preShutdown();
        if (bResult && (bResult = Activator.getDefault().saveDiscountSystems())) {
            bResult = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", (String)"\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e, \u0445\u043e\u0442\u0438\u0442\u0435 \u0432\u044b\u0439\u0442\u0438?");
        }
        return bResult;
    }

    public void postStartup() {
        super.postStartup();
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        pm.remove("org.eclipse.help.ui.browsersPreferencePage");
    }
}

