/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.synchronization;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.Transaction;
import org.hibernate.envers.revisioninfo.RevisionInfoGenerator;
import org.hibernate.envers.synchronization.AuditSync;
import org.hibernate.event.EventSource;

public class AuditSyncManager {
    private final Map<Transaction, AuditSync> auditSyncs = new ConcurrentHashMap<Transaction, AuditSync>();
    private final RevisionInfoGenerator revisionInfoGenerator;

    public AuditSyncManager(RevisionInfoGenerator revisionInfoGenerator) {
        this.revisionInfoGenerator = revisionInfoGenerator;
    }

    public AuditSync get(EventSource session) {
        Transaction transaction = session.getTransaction();
        AuditSync verSync = this.auditSyncs.get(transaction);
        if (verSync == null) {
            verSync = new AuditSync(this, session, this.revisionInfoGenerator);
            this.auditSyncs.put(transaction, verSync);
            transaction.registerSynchronization(verSync);
        }
        return verSync;
    }

    public void remove(Transaction transaction) {
        this.auditSyncs.remove(transaction);
    }
}

