/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain.payment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.Length;
import ru.ssa.cashadmin.domain.payment.Agent;
import ru.ssa.cashadmin.domain.payment.Provider;

@Entity
@Table(name="terminal")
@MappedSuperclass
public class Terminal
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue
    private Integer terminalid;
    @NotNull
    private String agentcode;
    @ManyToOne
    @JoinColumn(name="agentcode", referencedColumnName="code", insertable=false, updatable=false)
    @NotNull
    @NotFound(action=NotFoundAction.IGNORE)
    private Agent agent;
    @NotNull
    @Length(max=100, min=1)
    private String terminalcode;
    @Length(max=255)
    private String address;
    @OneToMany(mappedBy="terminalid", cascade={CascadeType.ALL})
    private List<Provider> providers = new ArrayList<Provider>();

    protected Terminal() {
    }

    public Integer getTerminalid() {
        return this.terminalid;
    }

    public void setTerminalid(Integer terminalid) {
        this.terminalid = terminalid;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
        this.agentcode = agent != null ? agent.getCode() : null;
    }

    public String getTerminalcode() {
        return this.terminalcode;
    }

    public void setTerminalcode(String terminalcode) {
        this.terminalcode = terminalcode;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setProviders(List<Provider> providers) {
        this.providers = providers;
    }

    public List<Provider> getProviders() {
        return this.providers;
    }

    public String getAgentcode() {
        return this.agentcode;
    }

    public void setAgentcode(String agentcode) {
        this.agentcode = agentcode;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.terminalid == null ? 0 : this.terminalid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Terminal other = (Terminal)obj;
        return !(this.terminalid == null ? other.terminalid != null : !this.terminalid.equals(other.terminalid));
    }

    public String toString() {
        return "Terminal [terminalid=" + this.terminalid + ", agentcode=" + this.agentcode + ", terminalcode=" + this.terminalcode + "]";
    }
}

