/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.action;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.yuki.action.SecurityActionImpl;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.model.ModelActivator;

public class DirectoryRemoveAction<E>
extends SecurityActionImpl<E> {
    private static final String PLUGIN_ID = "yuki.directory.gui";
    public static final String ID = "ru.ssa.artixadmin.action.DirectoryRemoveAction";
    private static final Logger log = LoggerFactory.getLogger(DirectoryRemoveAction.class);

    public DirectoryRemoveAction(Class<E> cl) {
        super(cl, false);
        this.setText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
        this.setId(ID);
        ArtixAdminImages images = ArtixAdminImages.getDefault();
        this.setImageDescriptor(images.getImageDescriptor("plane/16x16/delete"));
        this.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
        this.setEnabled(false);
    }

    public void run() {
        ISelection selection = this.window.getSelectionService().getSelection();
        log.trace("selection {}", (Object)selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435...", (String)"\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442?")) {
                if (structuredSelection.size() > 5) {
                    try {
                        ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.getClazz()).doRemoveAll((Collection)structuredSelection.toList());
                    }
                    catch (ExecuteQueryException e) {
                        log.error("Couldn't remove.", (Throwable)e);
                        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c.", (String)("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c." + e.getMessage()), (IStatus)new Status(4, PLUGIN_ID, "Error", (Throwable)e));
                    }
                } else {
                    for (Object obj : structuredSelection.toList()) {
                        try {
                            ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.getClazz()).doRemove(obj);
                        }
                        catch (ExecuteQueryException e) {
                            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c.", (String)("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c." + e.getMessage()), (IStatus)new Status(4, PLUGIN_ID, "Error", (Throwable)e));
                        }
                    }
                }
                ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.getClazz()).doRefresh();
            }
        } else {
            log.error("selection is not instanceof {}", IStructuredSelection.class);
        }
    }
}

