/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.dialogs.discountsystem.DiscountConditionValuePanel;
import su.artix.discountmanager.dialogs.discountsystem.ParsedControlsMeta;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControl;
import su.artix.yuki.discount.condition.domain.xml.ConditionCustomeType;
import su.artix.yuki.discount.condition.domain.xml.ConditionTemplate;
import su.artix.yuki.discount.condition.domain.xml.ConditionTemplateValue;
import su.artix.yuki.discount.condition.domain.xml.ConstListItem;
import su.artix.yuki.discount.condition.domain.xml.ConstructorWidgetType;
import su.artix.yuki.discount.condition.template.dao.ConditionCustomTypeDAO;

public class DiscountConditionTemplateFillerPanel
extends Composite {
    private ConditionTemplate template;
    private String condition;
    private String description;
    private Map<ParsedControlsMeta, ConditionTemplateValue> metaTempValues;
    private DiscountConditionValuePanel valuePanel;
    private ConditionCustomTypeDAO customTypeDao;

    public DiscountConditionTemplateFillerPanel(Composite parent, int style, ConditionTemplate conditionTemplate) {
        super(parent, style);
        this.template = conditionTemplate.copy();
        this.customTypeDao = Activator.getDefault().getBeanByClass(ConditionCustomTypeDAO.class);
        this.metaTempValues = new HashMap<ParsedControlsMeta, ConditionTemplateValue>(5);
        this.init();
    }

    private void init() {
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        List<ParsedControlsMeta> metas = this.parseTemplate();
        this.valuePanel = new DiscountConditionValuePanel(this, 0, metas);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.valuePanel);
    }

    private List<ParsedControlsMeta> parseTemplate() {
        ArrayList<ParsedControlsMeta> metas = new ArrayList<ParsedControlsMeta>();
        ParsedControlsMeta meta = null;
        for (ConditionTemplateValue value : this.template.getValues()) {
            ConstructorWidgetType wType = ConstructorWidgetType.getControlTypeFromString((String)value.getType());
            if (ConstructorWidgetType.Unknown == wType) {
                if (this.customTypeDao != null) {
                    ConditionCustomeType customType = this.customTypeDao.getValueType(value.getType());
                    meta = new ParsedControlsMeta(ConstructorWidgetType.getControlTypeFromString((String)customType.getValue().getXmlType()), value.getLabel());
                    meta.setConstListType(customType.getValue().getMode());
                    String defValue = null;
                    defValue = value.getDefaultValue() != null ? value.getDefaultValue() : customType.getValue().getDefaultValue();
                    meta.setDefaultValue(defValue);
                    for (ConstListItem item : customType.getValue().getList()) {
                        meta.addValue(item.getDisplay(), item.getValue());
                    }
                } else {
                    meta = new ParsedControlsMeta(ConstructorWidgetType.Text, value.getLabel());
                }
            } else {
                meta = new ParsedControlsMeta(wType, value.getLabel());
                if (value.getDefaultValue() != null) {
                    meta.setDefaultValue(value.getDefaultValue());
                }
            }
            this.metaTempValues.put(meta, value);
            metas.add(meta);
        }
        return metas;
    }

    public int getValues() {
        Map<ParsedControlsMeta, DiscountConditionControl> controls = this.valuePanel.getControlsWithMetaMap();
        Boolean isValid = true;
        for (DiscountConditionControl control : controls.values()) {
            if (control.isValid()) continue;
            isValid = false;
            break;
        }
        if (isValid.booleanValue()) {
            this.description = this.template.getSpecification();
            this.condition = this.template.getDefinition();
            for (Map.Entry<ParsedControlsMeta, DiscountConditionControl> entry : controls.entrySet()) {
                DiscountConditionControl control = entry.getValue();
                String tech = control.getText();
                String desc = control.getDesc();
                this.condition = StringUtils.replaceOnce((String)this.condition, (String)"${..}", (String)tech);
                this.description = StringUtils.replaceOnce((String)this.description, (String)"[..]", (String)desc);
                if (tech != null && tech.startsWith("u\"") && tech.endsWith("\"")) {
                    tech = StringUtils.substringBetween((String)tech, (String)"u\"", (String)"\"");
                }
                this.metaTempValues.get(entry.getKey()).setDefaultValue(tech);
            }
            return 0;
        }
        return 1;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getDescription() {
        return this.description;
    }

    public ConditionTemplate getTemplate() {
        return this.template;
    }
}

